# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictBytes, StrictStr
from typing import List, Optional, Union
from typing_extensions import Annotated
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.invoice_details import InvoiceDetails
from empire_platform_api_public_client.models.invoice_group_batch import InvoiceGroupBatch
from empire_platform_api_public_client.models.invoice_status import InvoiceStatus
from empire_platform_api_public_client.models.settlement import Settlement
from empire_platform_api_public_client.models.settlement_per_source import SettlementPerSource
from empire_platform_api_public_client.models.settlement_source_type import SettlementSourceType
from empire_platform_api_public_client.models.uiosi_overview import UiosiOverview

from empire_platform_api_public_client.api_client import ApiClient, RequestSerialized
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.rest import RESTResponseType


class FinanceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def download_all_finance_invoice_group_pdfs(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """download_all_finance_invoice_group_pdfs

        Fetch Invoice PDFs for an Invoice Group packaged in a ZIP archive  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_all_finance_invoice_group_pdfs_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_all_finance_invoice_group_pdfs_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """download_all_finance_invoice_group_pdfs

        Fetch Invoice PDFs for an Invoice Group packaged in a ZIP archive  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_all_finance_invoice_group_pdfs_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_all_finance_invoice_group_pdfs_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """download_all_finance_invoice_group_pdfs

        Fetch Invoice PDFs for an Invoice Group packaged in a ZIP archive  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_all_finance_invoice_group_pdfs_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_all_finance_invoice_group_pdfs_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/octet-stream', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/finance/invoice-groups/{id}/download-all',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_invoice(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InvoiceDetails:
        """get_finance_invoice

        Fetch an Invoice by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InvoiceDetails",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_invoice_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InvoiceDetails]:
        """get_finance_invoice

        Fetch an Invoice by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InvoiceDetails",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_invoice_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_invoice

        Fetch an Invoice by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InvoiceDetails",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_invoice_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/finance/invoices/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_invoices(
        self,
        limit: Annotated[int, Field(le=100, strict=True, ge=1, description="Number of records to return on a page")],
        offset: Annotated[int, Field(strict=True, ge=0, description="Offset in the list of records to return")],
        period_from: date,
        period_to: date,
        statuses: List[InvoiceStatus],
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InvoiceGroupBatch:
        """get_finance_invoices

        Fetch a paginated, filterable list of Invoices  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoices_serialize(
            limit=limit,
            offset=offset,
            period_from=period_from,
            period_to=period_to,
            statuses=statuses,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InvoiceGroupBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_invoices_with_http_info(
        self,
        limit: Annotated[int, Field(le=100, strict=True, ge=1, description="Number of records to return on a page")],
        offset: Annotated[int, Field(strict=True, ge=0, description="Offset in the list of records to return")],
        period_from: date,
        period_to: date,
        statuses: List[InvoiceStatus],
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InvoiceGroupBatch]:
        """get_finance_invoices

        Fetch a paginated, filterable list of Invoices  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoices_serialize(
            limit=limit,
            offset=offset,
            period_from=period_from,
            period_to=period_to,
            statuses=statuses,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InvoiceGroupBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_invoices_without_preload_content(
        self,
        limit: Annotated[int, Field(le=100, strict=True, ge=1, description="Number of records to return on a page")],
        offset: Annotated[int, Field(strict=True, ge=0, description="Offset in the list of records to return")],
        period_from: date,
        period_to: date,
        statuses: List[InvoiceStatus],
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_invoices

        Fetch a paginated, filterable list of Invoices  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoices_serialize(
            limit=limit,
            offset=offset,
            period_from=period_from,
            period_to=period_to,
            statuses=statuses,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InvoiceGroupBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_invoices_serialize(
        self,
        limit,
        offset,
        period_from,
        period_to,
        statuses,
        x_participant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'statuses': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if period_from is not None:
            if isinstance(period_from, date):
                _query_params.append(
                    (
                        'periodFrom',
                        period_from.isoformat()
                    )
                )
            else:
                _query_params.append(('periodFrom', period_from))
            
        if period_to is not None:
            if isinstance(period_to, date):
                _query_params.append(
                    (
                        'periodTo',
                        period_to.isoformat()
                    )
                )
            else:
                _query_params.append(('periodTo', period_to))
            
        if statuses is not None:
            
            _query_params.append(('statuses', statuses))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/finance/invoices',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_settlement_per_day(
        self,
        period_from: date,
        period_to: date,
        sources: List[SettlementSourceType],
        product_types: Annotated[Optional[List[AuctionProductType]], Field(description="List of Auction Product Types (optional)")] = None,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        border_direction: Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None,
        timescales: Annotated[Optional[List[AuctionTimescale]], Field(description="List of Auction Timescales (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[Settlement]:
        """get_finance_settlement_per_day

        Fetch a filterable list of Settlements per days  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param product_types: List of Auction Product Types (optional)
        :type product_types: List[AuctionProductType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescales: List of Auction Timescales (optional)
        :type timescales: List[AuctionTimescale]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_settlement_per_day_serialize(
            period_from=period_from,
            period_to=period_to,
            sources=sources,
            product_types=product_types,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            timescales=timescales,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Settlement]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_settlement_per_day_with_http_info(
        self,
        period_from: date,
        period_to: date,
        sources: List[SettlementSourceType],
        product_types: Annotated[Optional[List[AuctionProductType]], Field(description="List of Auction Product Types (optional)")] = None,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        border_direction: Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None,
        timescales: Annotated[Optional[List[AuctionTimescale]], Field(description="List of Auction Timescales (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[Settlement]]:
        """get_finance_settlement_per_day

        Fetch a filterable list of Settlements per days  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param product_types: List of Auction Product Types (optional)
        :type product_types: List[AuctionProductType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescales: List of Auction Timescales (optional)
        :type timescales: List[AuctionTimescale]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_settlement_per_day_serialize(
            period_from=period_from,
            period_to=period_to,
            sources=sources,
            product_types=product_types,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            timescales=timescales,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Settlement]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_settlement_per_day_without_preload_content(
        self,
        period_from: date,
        period_to: date,
        sources: List[SettlementSourceType],
        product_types: Annotated[Optional[List[AuctionProductType]], Field(description="List of Auction Product Types (optional)")] = None,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        border_direction: Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None,
        timescales: Annotated[Optional[List[AuctionTimescale]], Field(description="List of Auction Timescales (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_settlement_per_day

        Fetch a filterable list of Settlements per days  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param product_types: List of Auction Product Types (optional)
        :type product_types: List[AuctionProductType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescales: List of Auction Timescales (optional)
        :type timescales: List[AuctionTimescale]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_settlement_per_day_serialize(
            period_from=period_from,
            period_to=period_to,
            sources=sources,
            product_types=product_types,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            timescales=timescales,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Settlement]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_settlement_per_day_serialize(
        self,
        period_from,
        period_to,
        sources,
        product_types,
        x_participant_id,
        border_direction,
        timescales,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sources': 'multi',
            'productTypes': 'multi',
            'timescales': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if period_from is not None:
            if isinstance(period_from, date):
                _query_params.append(
                    (
                        'periodFrom',
                        period_from.isoformat()
                    )
                )
            else:
                _query_params.append(('periodFrom', period_from))
            
        if period_to is not None:
            if isinstance(period_to, date):
                _query_params.append(
                    (
                        'periodTo',
                        period_to.isoformat()
                    )
                )
            else:
                _query_params.append(('periodTo', period_to))
            
        if sources is not None:
            
            _query_params.append(('sources', sources))
            
        if product_types is not None:
            
            _query_params.append(('productTypes', product_types))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if timescales is not None:
            
            _query_params.append(('timescales', timescales))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/finance/settlement/day',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_settlement_per_source(
        self,
        period_from: date,
        period_to: date,
        sources: List[SettlementSourceType],
        product_types: Annotated[Optional[List[AuctionProductType]], Field(description="List of Auction Product Types (optional)")] = None,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        border_direction: Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None,
        timescales: Annotated[Optional[List[AuctionTimescale]], Field(description="List of Auction Timescales (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[SettlementPerSource]:
        """get_finance_settlement_per_source

        Fetch a filterable list of Settlements per Source  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param product_types: List of Auction Product Types (optional)
        :type product_types: List[AuctionProductType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescales: List of Auction Timescales (optional)
        :type timescales: List[AuctionTimescale]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_settlement_per_source_serialize(
            period_from=period_from,
            period_to=period_to,
            sources=sources,
            product_types=product_types,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            timescales=timescales,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SettlementPerSource]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_settlement_per_source_with_http_info(
        self,
        period_from: date,
        period_to: date,
        sources: List[SettlementSourceType],
        product_types: Annotated[Optional[List[AuctionProductType]], Field(description="List of Auction Product Types (optional)")] = None,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        border_direction: Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None,
        timescales: Annotated[Optional[List[AuctionTimescale]], Field(description="List of Auction Timescales (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[SettlementPerSource]]:
        """get_finance_settlement_per_source

        Fetch a filterable list of Settlements per Source  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param product_types: List of Auction Product Types (optional)
        :type product_types: List[AuctionProductType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescales: List of Auction Timescales (optional)
        :type timescales: List[AuctionTimescale]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_settlement_per_source_serialize(
            period_from=period_from,
            period_to=period_to,
            sources=sources,
            product_types=product_types,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            timescales=timescales,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SettlementPerSource]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_settlement_per_source_without_preload_content(
        self,
        period_from: date,
        period_to: date,
        sources: List[SettlementSourceType],
        product_types: Annotated[Optional[List[AuctionProductType]], Field(description="List of Auction Product Types (optional)")] = None,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        border_direction: Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None,
        timescales: Annotated[Optional[List[AuctionTimescale]], Field(description="List of Auction Timescales (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_settlement_per_source

        Fetch a filterable list of Settlements per Source  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param product_types: List of Auction Product Types (optional)
        :type product_types: List[AuctionProductType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescales: List of Auction Timescales (optional)
        :type timescales: List[AuctionTimescale]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_settlement_per_source_serialize(
            period_from=period_from,
            period_to=period_to,
            sources=sources,
            product_types=product_types,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            timescales=timescales,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SettlementPerSource]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_settlement_per_source_serialize(
        self,
        period_from,
        period_to,
        sources,
        product_types,
        x_participant_id,
        border_direction,
        timescales,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sources': 'multi',
            'productTypes': 'multi',
            'timescales': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if period_from is not None:
            if isinstance(period_from, date):
                _query_params.append(
                    (
                        'periodFrom',
                        period_from.isoformat()
                    )
                )
            else:
                _query_params.append(('periodFrom', period_from))
            
        if period_to is not None:
            if isinstance(period_to, date):
                _query_params.append(
                    (
                        'periodTo',
                        period_to.isoformat()
                    )
                )
            else:
                _query_params.append(('periodTo', period_to))
            
        if sources is not None:
            
            _query_params.append(('sources', sources))
            
        if product_types is not None:
            
            _query_params.append(('productTypes', product_types))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if timescales is not None:
            
            _query_params.append(('timescales', timescales))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/finance/settlement/source',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_uiosi_overview(
        self,
        delivery_day: date,
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UiosiOverview:
        """get_finance_uiosi_overview

        Fetch \"Use it or Sell it\" data by given filters  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_UIOSI`   * `VIEW_ANY_UIOSI`

        :param delivery_day: (required)
        :type delivery_day: date
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_overview_serialize(
            delivery_day=delivery_day,
            border_direction=border_direction,
            timescale=timescale,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UiosiOverview",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_uiosi_overview_with_http_info(
        self,
        delivery_day: date,
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UiosiOverview]:
        """get_finance_uiosi_overview

        Fetch \"Use it or Sell it\" data by given filters  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_UIOSI`   * `VIEW_ANY_UIOSI`

        :param delivery_day: (required)
        :type delivery_day: date
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_overview_serialize(
            delivery_day=delivery_day,
            border_direction=border_direction,
            timescale=timescale,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UiosiOverview",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_uiosi_overview_without_preload_content(
        self,
        delivery_day: date,
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_uiosi_overview

        Fetch \"Use it or Sell it\" data by given filters  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_UIOSI`   * `VIEW_ANY_UIOSI`

        :param delivery_day: (required)
        :type delivery_day: date
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_overview_serialize(
            delivery_day=delivery_day,
            border_direction=border_direction,
            timescale=timescale,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UiosiOverview",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_uiosi_overview_serialize(
        self,
        delivery_day,
        border_direction,
        timescale,
        x_participant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_day is not None:
            if isinstance(delivery_day, date):
                _query_params.append(
                    (
                        'deliveryDay',
                        delivery_day.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryDay', delivery_day))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if timescale is not None:
            
            _query_params.append(('timescale', timescale.value))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/finance/uiosi-overview',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


