# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.border_direction_with_both import BorderDirectionWithBoth
from empire_platform_api_public_client.models.create_day_ahead_or_intra_day_default_bid_request import CreateDayAheadOrIntraDayDefaultBidRequest
from empire_platform_api_public_client.models.create_long_term_default_bid_request import CreateLongTermDefaultBidRequest
from empire_platform_api_public_client.models.created_default_bid import CreatedDefaultBid
from empire_platform_api_public_client.models.day_ahead_or_intra_day_default_bid import DayAheadOrIntraDayDefaultBid
from empire_platform_api_public_client.models.default_bid_batch import DefaultBidBatch
from empire_platform_api_public_client.models.default_bid_options import DefaultBidOptions
from empire_platform_api_public_client.models.default_bid_sort_by import DefaultBidSortBy
from empire_platform_api_public_client.models.long_term_default_bid import LongTermDefaultBid
from empire_platform_api_public_client.models.update_day_ahead_or_intra_day_default_bid_request import UpdateDayAheadOrIntraDayDefaultBidRequest
from empire_platform_api_public_client.models.update_long_term_default_bid_request import UpdateLongTermDefaultBidRequest

from empire_platform_api_public_client.api_client import ApiClient, RequestSerialized
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.rest import RESTResponseType


class DefaultBidApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_day_ahead_or_intra_day_default_bid(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        create_day_ahead_or_intra_day_default_bid_request: CreateDayAheadOrIntraDayDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatedDefaultBid:
        """create_day_ahead_or_intra_day_default_bid

        Create new Default Bid for Day Ahead or Intra Day product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_day_ahead_or_intra_day_default_bid_request: (required)
        :type create_day_ahead_or_intra_day_default_bid_request: CreateDayAheadOrIntraDayDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_day_ahead_or_intra_day_default_bid_serialize(
            x_participant_id=x_participant_id,
            create_day_ahead_or_intra_day_default_bid_request=create_day_ahead_or_intra_day_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatedDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_day_ahead_or_intra_day_default_bid_with_http_info(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        create_day_ahead_or_intra_day_default_bid_request: CreateDayAheadOrIntraDayDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatedDefaultBid]:
        """create_day_ahead_or_intra_day_default_bid

        Create new Default Bid for Day Ahead or Intra Day product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_day_ahead_or_intra_day_default_bid_request: (required)
        :type create_day_ahead_or_intra_day_default_bid_request: CreateDayAheadOrIntraDayDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_day_ahead_or_intra_day_default_bid_serialize(
            x_participant_id=x_participant_id,
            create_day_ahead_or_intra_day_default_bid_request=create_day_ahead_or_intra_day_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatedDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_day_ahead_or_intra_day_default_bid_without_preload_content(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        create_day_ahead_or_intra_day_default_bid_request: CreateDayAheadOrIntraDayDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create_day_ahead_or_intra_day_default_bid

        Create new Default Bid for Day Ahead or Intra Day product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_day_ahead_or_intra_day_default_bid_request: (required)
        :type create_day_ahead_or_intra_day_default_bid_request: CreateDayAheadOrIntraDayDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_day_ahead_or_intra_day_default_bid_serialize(
            x_participant_id=x_participant_id,
            create_day_ahead_or_intra_day_default_bid_request=create_day_ahead_or_intra_day_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatedDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_day_ahead_or_intra_day_default_bid_serialize(
        self,
        x_participant_id,
        create_day_ahead_or_intra_day_default_bid_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter
        if create_day_ahead_or_intra_day_default_bid_request is not None:
            _body_params = create_day_ahead_or_intra_day_default_bid_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/default-bids/day-ahead-or-intra-day',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_long_term_default_bid(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        create_long_term_default_bid_request: CreateLongTermDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatedDefaultBid:
        """create_long_term_default_bid

        Create new Default Bid for Long Term product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_LONG_TERM_DEFAULT_BID`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_long_term_default_bid_request: (required)
        :type create_long_term_default_bid_request: CreateLongTermDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_long_term_default_bid_serialize(
            x_participant_id=x_participant_id,
            create_long_term_default_bid_request=create_long_term_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatedDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_long_term_default_bid_with_http_info(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        create_long_term_default_bid_request: CreateLongTermDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatedDefaultBid]:
        """create_long_term_default_bid

        Create new Default Bid for Long Term product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_LONG_TERM_DEFAULT_BID`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_long_term_default_bid_request: (required)
        :type create_long_term_default_bid_request: CreateLongTermDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_long_term_default_bid_serialize(
            x_participant_id=x_participant_id,
            create_long_term_default_bid_request=create_long_term_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatedDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_long_term_default_bid_without_preload_content(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        create_long_term_default_bid_request: CreateLongTermDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create_long_term_default_bid

        Create new Default Bid for Long Term product types  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `CREATE_LONG_TERM_DEFAULT_BID`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param create_long_term_default_bid_request: (required)
        :type create_long_term_default_bid_request: CreateLongTermDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_long_term_default_bid_serialize(
            x_participant_id=x_participant_id,
            create_long_term_default_bid_request=create_long_term_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatedDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_long_term_default_bid_serialize(
        self,
        x_participant_id,
        create_long_term_default_bid_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter
        if create_long_term_default_bid_request is not None:
            _body_params = create_long_term_default_bid_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/default-bids/long-term',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_default_bid(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """delete_default_bid

        Delete an existing Default Bid  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `DELETE_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_default_bid_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """delete_default_bid

        Delete an existing Default Bid  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `DELETE_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_default_bid_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete_default_bid

        Delete an existing Default Bid  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `DELETE_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_default_bid_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/default-bids/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_day_ahead_or_intra_day_default_bid(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DayAheadOrIntraDayDefaultBid:
        """get_day_ahead_or_intra_day_default_bid

        Fetch a Day Ahead or Intra Day Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_day_ahead_or_intra_day_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DayAheadOrIntraDayDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_day_ahead_or_intra_day_default_bid_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DayAheadOrIntraDayDefaultBid]:
        """get_day_ahead_or_intra_day_default_bid

        Fetch a Day Ahead or Intra Day Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_day_ahead_or_intra_day_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DayAheadOrIntraDayDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_day_ahead_or_intra_day_default_bid_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_day_ahead_or_intra_day_default_bid

        Fetch a Day Ahead or Intra Day Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_day_ahead_or_intra_day_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DayAheadOrIntraDayDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_day_ahead_or_intra_day_default_bid_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/default-bids/day-ahead-or-intra-day/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_default_bid_options(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DefaultBidOptions:
        """get_default_bid_options

        Fetch options for creating and all kinds of Default Bids  Returns allocation MTU size configuration for Auction Product Types  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `MANAGE_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_default_bid_options_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DefaultBidOptions",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_default_bid_options_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DefaultBidOptions]:
        """get_default_bid_options

        Fetch options for creating and all kinds of Default Bids  Returns allocation MTU size configuration for Auction Product Types  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `MANAGE_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_default_bid_options_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DefaultBidOptions",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_default_bid_options_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_default_bid_options

        Fetch options for creating and all kinds of Default Bids  Returns allocation MTU size configuration for Auction Product Types  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `MANAGE_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_default_bid_options_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DefaultBidOptions",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_default_bid_options_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/default-bids/options',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_default_bids(
        self,
        limit: Annotated[int, Field(le=100, strict=True, ge=1, description="Number of records to return on a page")],
        offset: Annotated[int, Field(strict=True, ge=0, description="Offset in the list of records to return")],
        sort_by: Annotated[DefaultBidSortBy, Field(description="Sort list by given attribute and direction")],
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: Annotated[datetime, Field(description="Filter for start of delivery period (aligned to MTUs)")],
        delivery_period_end: Annotated[datetime, Field(description="Filter for end of delivery period (aligned to MTUs)")],
        validity_period_start: Annotated[Optional[datetime], Field(description="Filter for start of validity period (optional)")] = None,
        validity_period_end: Annotated[Optional[datetime], Field(description="Filter for end of validity period (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DefaultBidBatch:
        """get_default_bids

        Fetch Default Bids for a given Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: DefaultBidSortBy
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs) (required)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs) (required)
        :type delivery_period_end: datetime
        :param validity_period_start: Filter for start of validity period (optional)
        :type validity_period_start: datetime
        :param validity_period_end: Filter for end of validity period (optional)
        :type validity_period_end: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_default_bids_serialize(
            limit=limit,
            offset=offset,
            sort_by=sort_by,
            x_participant_id=x_participant_id,
            product_types=product_types,
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            validity_period_start=validity_period_start,
            validity_period_end=validity_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DefaultBidBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_default_bids_with_http_info(
        self,
        limit: Annotated[int, Field(le=100, strict=True, ge=1, description="Number of records to return on a page")],
        offset: Annotated[int, Field(strict=True, ge=0, description="Offset in the list of records to return")],
        sort_by: Annotated[DefaultBidSortBy, Field(description="Sort list by given attribute and direction")],
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: Annotated[datetime, Field(description="Filter for start of delivery period (aligned to MTUs)")],
        delivery_period_end: Annotated[datetime, Field(description="Filter for end of delivery period (aligned to MTUs)")],
        validity_period_start: Annotated[Optional[datetime], Field(description="Filter for start of validity period (optional)")] = None,
        validity_period_end: Annotated[Optional[datetime], Field(description="Filter for end of validity period (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DefaultBidBatch]:
        """get_default_bids

        Fetch Default Bids for a given Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: DefaultBidSortBy
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs) (required)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs) (required)
        :type delivery_period_end: datetime
        :param validity_period_start: Filter for start of validity period (optional)
        :type validity_period_start: datetime
        :param validity_period_end: Filter for end of validity period (optional)
        :type validity_period_end: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_default_bids_serialize(
            limit=limit,
            offset=offset,
            sort_by=sort_by,
            x_participant_id=x_participant_id,
            product_types=product_types,
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            validity_period_start=validity_period_start,
            validity_period_end=validity_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DefaultBidBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_default_bids_without_preload_content(
        self,
        limit: Annotated[int, Field(le=100, strict=True, ge=1, description="Number of records to return on a page")],
        offset: Annotated[int, Field(strict=True, ge=0, description="Offset in the list of records to return")],
        sort_by: Annotated[DefaultBidSortBy, Field(description="Sort list by given attribute and direction")],
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: Annotated[datetime, Field(description="Filter for start of delivery period (aligned to MTUs)")],
        delivery_period_end: Annotated[datetime, Field(description="Filter for end of delivery period (aligned to MTUs)")],
        validity_period_start: Annotated[Optional[datetime], Field(description="Filter for start of validity period (optional)")] = None,
        validity_period_end: Annotated[Optional[datetime], Field(description="Filter for end of validity period (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_default_bids

        Fetch Default Bids for a given Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: DefaultBidSortBy
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs) (required)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs) (required)
        :type delivery_period_end: datetime
        :param validity_period_start: Filter for start of validity period (optional)
        :type validity_period_start: datetime
        :param validity_period_end: Filter for end of validity period (optional)
        :type validity_period_end: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_default_bids_serialize(
            limit=limit,
            offset=offset,
            sort_by=sort_by,
            x_participant_id=x_participant_id,
            product_types=product_types,
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            validity_period_start=validity_period_start,
            validity_period_end=validity_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DefaultBidBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_default_bids_serialize(
        self,
        limit,
        offset,
        sort_by,
        x_participant_id,
        product_types,
        border_direction,
        delivery_period_start,
        delivery_period_end,
        validity_period_start,
        validity_period_end,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'productTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if sort_by is not None:
            
            _query_params.append(('sortBy', sort_by.value))
            
        if product_types is not None:
            
            _query_params.append(('productTypes', product_types))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, datetime):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, datetime):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        if validity_period_start is not None:
            if isinstance(validity_period_start, datetime):
                _query_params.append(
                    (
                        'validityPeriodStart',
                        validity_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('validityPeriodStart', validity_period_start))
            
        if validity_period_end is not None:
            if isinstance(validity_period_end, datetime):
                _query_params.append(
                    (
                        'validityPeriodEnd',
                        validity_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('validityPeriodEnd', validity_period_end))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/default-bids',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_long_term_default_bid(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> LongTermDefaultBid:
        """get_long_term_default_bid

        Fetch a Long Term Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_long_term_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LongTermDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_long_term_default_bid_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[LongTermDefaultBid]:
        """get_long_term_default_bid

        Fetch a Long Term Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_long_term_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LongTermDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_long_term_default_bid_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_long_term_default_bid

        Fetch a Long Term Default Bid by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_DEFAULT_BIDS`   * `VIEW_ANY_DEFAULT_BIDS`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_long_term_default_bid_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LongTermDefaultBid",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_long_term_default_bid_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/default-bids/long-term/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_day_ahead_or_intra_day_default_bid(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        update_day_ahead_or_intra_day_default_bid_request: UpdateDayAheadOrIntraDayDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """update_day_ahead_or_intra_day_default_bid

        Update a Day Ahead or Intra Day Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_day_ahead_or_intra_day_default_bid_request: (required)
        :type update_day_ahead_or_intra_day_default_bid_request: UpdateDayAheadOrIntraDayDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_day_ahead_or_intra_day_default_bid_serialize(
            id=id,
            update_day_ahead_or_intra_day_default_bid_request=update_day_ahead_or_intra_day_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_day_ahead_or_intra_day_default_bid_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        update_day_ahead_or_intra_day_default_bid_request: UpdateDayAheadOrIntraDayDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """update_day_ahead_or_intra_day_default_bid

        Update a Day Ahead or Intra Day Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_day_ahead_or_intra_day_default_bid_request: (required)
        :type update_day_ahead_or_intra_day_default_bid_request: UpdateDayAheadOrIntraDayDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_day_ahead_or_intra_day_default_bid_serialize(
            id=id,
            update_day_ahead_or_intra_day_default_bid_request=update_day_ahead_or_intra_day_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_day_ahead_or_intra_day_default_bid_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        update_day_ahead_or_intra_day_default_bid_request: UpdateDayAheadOrIntraDayDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update_day_ahead_or_intra_day_default_bid

        Update a Day Ahead or Intra Day Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_DAY_AHEAD_OR_INTRA_DAY_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_day_ahead_or_intra_day_default_bid_request: (required)
        :type update_day_ahead_or_intra_day_default_bid_request: UpdateDayAheadOrIntraDayDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_day_ahead_or_intra_day_default_bid_serialize(
            id=id,
            update_day_ahead_or_intra_day_default_bid_request=update_day_ahead_or_intra_day_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_day_ahead_or_intra_day_default_bid_serialize(
        self,
        id,
        update_day_ahead_or_intra_day_default_bid_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_day_ahead_or_intra_day_default_bid_request is not None:
            _body_params = update_day_ahead_or_intra_day_default_bid_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/default-bids/day-ahead-or-intra-day/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_long_term_default_bid(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        update_long_term_default_bid_request: UpdateLongTermDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """update_long_term_default_bid

        Updat a Long Term Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_LONG_TERM_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_long_term_default_bid_request: (required)
        :type update_long_term_default_bid_request: UpdateLongTermDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_long_term_default_bid_serialize(
            id=id,
            update_long_term_default_bid_request=update_long_term_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_long_term_default_bid_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        update_long_term_default_bid_request: UpdateLongTermDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """update_long_term_default_bid

        Updat a Long Term Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_LONG_TERM_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_long_term_default_bid_request: (required)
        :type update_long_term_default_bid_request: UpdateLongTermDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_long_term_default_bid_serialize(
            id=id,
            update_long_term_default_bid_request=update_long_term_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_long_term_default_bid_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Internal unique ID of an entity")],
        update_long_term_default_bid_request: UpdateLongTermDefaultBidRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update_long_term_default_bid

        Updat a Long Term Default Bid by its identifier  Re-creates any existing default bid values  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_DEFAULT_BIDS`   * `MANAGE_ANY_DEFAULT_BIDS`  __Generates Audit Log Entry:__ `UPDATE_LONG_TERM_DEFAULT_BID`

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param update_long_term_default_bid_request: (required)
        :type update_long_term_default_bid_request: UpdateLongTermDefaultBidRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_long_term_default_bid_serialize(
            id=id,
            update_long_term_default_bid_request=update_long_term_default_bid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_long_term_default_bid_serialize(
        self,
        id,
        update_long_term_default_bid_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_long_term_default_bid_request is not None:
            _body_params = update_long_term_default_bid_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/default-bids/long-term/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


