# bizerror

Collections of common business errors.

## Install

```shell
pip install bizerror
```

## Installed command utils

- bizerror-generator

## Shipped exception classes

- OK
- BizError
- SysError
    - UndefinedError
    - DatabaseError
    - CacheError
    - MessageQueueError
    - AnotherServiceError
- HttpError
    - RequestExpired
    - NotSupportedHttpMethod
    - BadResponseContent
    - NoMatchingRouteFound
    - ReqeustForbidden
    - NoUpstreamServerAvailabe
- ConfigError
    - MissingConfigItem
- DataError
    - TargetNotFound
- AuthError
    - AccountLockedError
    - AccountTemporaryLockedError
    - UserPasswordError
    - AppAuthFailed
    - TsExpiredError
    - AccountDisabledError
    - AccountStatusError
    - AccountRemovedError
    - LoginRequired
    - AccessDenied
    - UserDoesNotExist
    - BadUserToken
    - ReqidDuplicateError
- TypeError
    - ParseJsonError
- ParamError
    - MissingParameter
    - BadParameter
    - BadParameterType
    - StringTooShort
    - StringTooLong
    - MissingField
    - WrongFieldType
    - WrongParameterType
    - ValueExceedsMaxLimit
    - ValueLessThanMinLimit
- FormError
    - CaptchaOnlyAllowedOnce
    - CaptchaValidateFailed
    - RepeatedlySubmitForm
    - CaptchaRequired
- LogicError
- CastFailedError
    - CastToIntegerFailed
    - CastToFloatFailed
    - CastToNumbericFailed
    - CastToBooleanFailed
    - CastToStringFailed
    - NotSupportedTypeToCast
- PermissionError
    - NoPermissionError
    - NoReadPermissionError
    - NoWritePermissionError
    - NoDeletePermissionError
    - NoAccessPermissionError
    - NoPermissionToCleanCacheError

## Release Notes

### v0.4.9

- bizerror.BizError add init by a dict supporting.
- Add bizerror.PermissionError(s).

### v0.4.7

- Add BizError.update.
- Add CastFailedError.

### v0.4.6

- Add BadResponseContent.

### v0.4.5

- Add StringTooShort and StringTooLong.
- Fix bizerror.BizError(another_bizerror) problem.

### v0.4.2

- Fix unicode encode/decode problems.
- Support python3 only.

### v0.4.1

- Add UserDoesNotExist.
- Add BadUserToken.

### v0.4.0

- Get error message by error class name, so that we can provide error message override function.

### v0.3.1

- Fix xlsxhelper dependencies problem.

### v0.3.0

- Add message parameters support.
- Add exception classes.
- Add class generator and tempalte maker.

### v0.2.3

- Add NotSupportedTypeToCast error.

### v0.2.0

- Fix get_error_message always use default language problem.
- Add BizError.MESSAGE classproperty.

### V0.2.0

- Add auto generate mechanism.
- Add language support.


### v0.1.0

- Add BizError base class.
- Add some common errors.
