"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.  # noqa: E501

    The version of the OpenAPI document: 2022-10-17
    Contact: developers@klaviyo.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.flow_update_query import FlowUpdateQuery
from openapi_client.model.get_catalog_items4_xx_response import GetCatalogItems4XXResponse


class FlowsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_flow_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flows/{id}/',
                'operation_id': 'get_flow',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_flow_action',
                    'fields_flow',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_flow_action',
                    'fields_flow',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_flow_action',): {

                        "ACTION_TYPE": "action_type",
                        "STATUS": "status",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "SETTINGS": "settings",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_OPTIONS": "send_options",
                        "SEND_OPTIONS.USE_SMART_SENDING": "send_options.use_smart_sending",
                        "SEND_OPTIONS.IS_TRANSACTIONAL": "send_options.is_transactional",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language"
                    },
                    ('fields_flow',): {

                        "NAME": "name",
                        "STATUS": "status",
                        "ARCHIVED": "archived",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "TRIGGER_TYPE": "trigger_type"
                    },
                    ('include',): {

                        "FLOW-ACTIONS": "flow-actions"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_flow_action':
                        ([str],),
                    'fields_flow':
                        ([str],),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_flow_action': 'fields[flow-action]',
                    'fields_flow': 'fields[flow]',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'fields_flow_action': 'query',
                    'fields_flow': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'fields_flow_action': 'csv',
                    'fields_flow': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_action_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flow-actions/{id}/',
                'operation_id': 'get_flow_action',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_flow_action',
                    'fields_flow_message',
                    'fields_flow',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_flow_action',
                    'fields_flow_message',
                    'fields_flow',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_flow_action',): {

                        "ACTION_TYPE": "action_type",
                        "STATUS": "status",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "SETTINGS": "settings",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_OPTIONS": "send_options",
                        "SEND_OPTIONS.USE_SMART_SENDING": "send_options.use_smart_sending",
                        "SEND_OPTIONS.IS_TRANSACTIONAL": "send_options.is_transactional",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language"
                    },
                    ('fields_flow_message',): {

                        "NAME": "name",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "CREATED": "created",
                        "UPDATED": "updated"
                    },
                    ('fields_flow',): {

                        "NAME": "name",
                        "STATUS": "status",
                        "ARCHIVED": "archived",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "TRIGGER_TYPE": "trigger_type"
                    },
                    ('include',): {

                        "FLOW-MESSAGES": "flow-messages",
                        "FLOWS": "flows"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_flow_action':
                        ([str],),
                    'fields_flow_message':
                        ([str],),
                    'fields_flow':
                        ([str],),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_flow_action': 'fields[flow-action]',
                    'fields_flow_message': 'fields[flow-message]',
                    'fields_flow': 'fields[flow]',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'fields_flow_action': 'query',
                    'fields_flow_message': 'query',
                    'fields_flow': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'fields_flow_action': 'csv',
                    'fields_flow_message': 'csv',
                    'fields_flow': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_action_flow_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flow-actions/{action_id}/flow/',
                'operation_id': 'get_flow_action_flow',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'action_id',
                    'fields_flow',
                ],
                'required': [
                    'action_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_flow',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_flow',): {

                        "NAME": "name",
                        "STATUS": "status",
                        "ARCHIVED": "archived",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "TRIGGER_TYPE": "trigger_type"
                    },
                },
                'openapi_types': {
                    'action_id':
                        (str,),
                    'fields_flow':
                        ([str],),
                },
                'attribute_map': {
                    'action_id': 'action_id',
                    'fields_flow': 'fields[flow]',
                },
                'location_map': {
                    'action_id': 'path',
                    'fields_flow': 'query',
                },
                'collection_format_map': {
                    'fields_flow': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_action_messages_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flow-actions/{action_id}/flow-messages/',
                'operation_id': 'get_flow_action_messages',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'action_id',
                    'fields_flow_message',
                    'filter',
                    'sort',
                ],
                'required': [
                    'action_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_flow_message',
                    'sort',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_flow_message',): {

                        "NAME": "name",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "CREATED": "created",
                        "UPDATED": "updated"
                    },
                    ('sort',): {

                        "CREATED": "created",
                        "-CREATED": "-created",
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "UPDATED": "updated",
                        "-UPDATED": "-updated"
                    },
                },
                'openapi_types': {
                    'action_id':
                        (str,),
                    'fields_flow_message':
                        ([str],),
                    'filter':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'action_id': 'action_id',
                    'fields_flow_message': 'fields[flow-message]',
                    'filter': 'filter',
                    'sort': 'sort',
                },
                'location_map': {
                    'action_id': 'path',
                    'fields_flow_message': 'query',
                    'filter': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'fields_flow_message': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_action_relationships_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flow-actions/{id}/relationships/{related_resource}/',
                'operation_id': 'get_flow_action_relationships',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'related_resource',
                    'filter',
                    'sort',
                ],
                'required': [
                    'id',
                    'related_resource',
                ],
                'nullable': [
                ],
                'enum': [
                    'related_resource',
                    'sort',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('related_resource',): {

                        "FLOW": "flow",
                        "FLOW-MESSAGES": "flow-messages"
                    },
                    ('sort',): {

                        "CREATED": "created",
                        "-CREATED": "-created",
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "UPDATED": "updated",
                        "-UPDATED": "-updated"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'related_resource':
                        (str,),
                    'filter':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'related_resource': 'related_resource',
                    'filter': 'filter',
                    'sort': 'sort',
                },
                'location_map': {
                    'id': 'path',
                    'related_resource': 'path',
                    'filter': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_flow_actions_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flows/{flow_id}/flow-actions/',
                'operation_id': 'get_flow_flow_actions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'flow_id',
                    'fields_flow_action',
                    'filter',
                    'sort',
                ],
                'required': [
                    'flow_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_flow_action',
                    'sort',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_flow_action',): {

                        "ACTION_TYPE": "action_type",
                        "STATUS": "status",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "SETTINGS": "settings",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_OPTIONS": "send_options",
                        "SEND_OPTIONS.USE_SMART_SENDING": "send_options.use_smart_sending",
                        "SEND_OPTIONS.IS_TRANSACTIONAL": "send_options.is_transactional",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language"
                    },
                    ('sort',): {

                        "ACTION_TYPE": "action_type",
                        "-ACTION_TYPE": "-action_type",
                        "CREATED": "created",
                        "-CREATED": "-created",
                        "ID": "id",
                        "-ID": "-id",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "UPDATED": "updated",
                        "-UPDATED": "-updated"
                    },
                },
                'openapi_types': {
                    'flow_id':
                        (str,),
                    'fields_flow_action':
                        ([str],),
                    'filter':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'flow_id': 'flow_id',
                    'fields_flow_action': 'fields[flow-action]',
                    'filter': 'filter',
                    'sort': 'sort',
                },
                'location_map': {
                    'flow_id': 'path',
                    'fields_flow_action': 'query',
                    'filter': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'fields_flow_action': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_message_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flow-messages/{id}/',
                'operation_id': 'get_flow_message',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_flow_action',
                    'fields_flow_message',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_flow_action',
                    'fields_flow_message',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_flow_action',): {

                        "ACTION_TYPE": "action_type",
                        "STATUS": "status",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "SETTINGS": "settings",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_OPTIONS": "send_options",
                        "SEND_OPTIONS.USE_SMART_SENDING": "send_options.use_smart_sending",
                        "SEND_OPTIONS.IS_TRANSACTIONAL": "send_options.is_transactional",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language"
                    },
                    ('fields_flow_message',): {

                        "NAME": "name",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "CREATED": "created",
                        "UPDATED": "updated"
                    },
                    ('include',): {

                        "FLOW-ACTION": "flow-action"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_flow_action':
                        ([str],),
                    'fields_flow_message':
                        ([str],),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_flow_action': 'fields[flow-action]',
                    'fields_flow_message': 'fields[flow-message]',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'fields_flow_action': 'query',
                    'fields_flow_message': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'fields_flow_action': 'csv',
                    'fields_flow_message': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_message_action_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flow-messages/{message_id}/flow-action/',
                'operation_id': 'get_flow_message_action',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'message_id',
                    'fields_flow_action',
                ],
                'required': [
                    'message_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_flow_action',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_flow_action',): {

                        "ACTION_TYPE": "action_type",
                        "STATUS": "status",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "SETTINGS": "settings",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_OPTIONS": "send_options",
                        "SEND_OPTIONS.USE_SMART_SENDING": "send_options.use_smart_sending",
                        "SEND_OPTIONS.IS_TRANSACTIONAL": "send_options.is_transactional",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language"
                    },
                },
                'openapi_types': {
                    'message_id':
                        (str,),
                    'fields_flow_action':
                        ([str],),
                },
                'attribute_map': {
                    'message_id': 'message_id',
                    'fields_flow_action': 'fields[flow-action]',
                },
                'location_map': {
                    'message_id': 'path',
                    'fields_flow_action': 'query',
                },
                'collection_format_map': {
                    'fields_flow_action': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_message_relationships_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flow-messages/{id}/relationships/{related_resource}/',
                'operation_id': 'get_flow_message_relationships',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'related_resource',
                ],
                'required': [
                    'id',
                    'related_resource',
                ],
                'nullable': [
                ],
                'enum': [
                    'related_resource',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('related_resource',): {

                        "FLOW-ACTION": "flow-action"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'related_resource':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'related_resource': 'related_resource',
                },
                'location_map': {
                    'id': 'path',
                    'related_resource': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flow_relationships_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flows/{id}/relationships/{related_resource}/',
                'operation_id': 'get_flow_relationships',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'related_resource',
                    'filter',
                    'sort',
                ],
                'required': [
                    'id',
                    'related_resource',
                ],
                'nullable': [
                ],
                'enum': [
                    'related_resource',
                    'sort',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('related_resource',): {

                        "FLOW-ACTIONS": "flow-actions"
                    },
                    ('sort',): {

                        "CREATED": "created",
                        "-CREATED": "-created",
                        "ID": "id",
                        "-ID": "-id",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "UPDATED": "updated",
                        "-UPDATED": "-updated"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'related_resource':
                        (str,),
                    'filter':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'related_resource': 'related_resource',
                    'filter': 'filter',
                    'sort': 'sort',
                },
                'location_map': {
                    'id': 'path',
                    'related_resource': 'path',
                    'filter': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_flows_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flows/',
                'operation_id': 'get_flows',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'fields_flow_action',
                    'fields_flow',
                    'filter',
                    'include',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'fields_flow_action',
                    'fields_flow',
                    'include',
                    'sort',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_flow_action',): {

                        "ACTION_TYPE": "action_type",
                        "STATUS": "status",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "SETTINGS": "settings",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_OPTIONS": "send_options",
                        "SEND_OPTIONS.USE_SMART_SENDING": "send_options.use_smart_sending",
                        "SEND_OPTIONS.IS_TRANSACTIONAL": "send_options.is_transactional",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language"
                    },
                    ('fields_flow',): {

                        "NAME": "name",
                        "STATUS": "status",
                        "ARCHIVED": "archived",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "TRIGGER_TYPE": "trigger_type"
                    },
                    ('include',): {

                        "FLOW-ACTIONS": "flow-actions"
                    },
                    ('sort',): {

                        "CREATED": "created",
                        "-CREATED": "-created",
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "TRIGGER_TYPE": "trigger_type",
                        "-TRIGGER_TYPE": "-trigger_type",
                        "UPDATED": "updated",
                        "-UPDATED": "-updated"
                    },
                },
                'openapi_types': {
                    'fields_flow_action':
                        ([str],),
                    'fields_flow':
                        ([str],),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'fields_flow_action': 'fields[flow-action]',
                    'fields_flow': 'fields[flow]',
                    'filter': 'filter',
                    'include': 'include',
                    'sort': 'sort',
                },
                'location_map': {
                    'fields_flow_action': 'query',
                    'fields_flow': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'fields_flow_action': 'csv',
                    'fields_flow': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_flow_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/flows/{id}/',
                'operation_id': 'update_flow',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'flow_update_query',
                ],
                'required': [
                    'id',
                    'flow_update_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'flow_update_query':
                        (FlowUpdateQuery,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'flow_update_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def get_flow(
        self,
        id,
        **kwargs
    ):
        """Get Flow  # noqa: E501

        Get a flow with the given flow ID. Request specific fields using [sparse fieldsets](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#sparse-fieldsets). Include parameters can be provided to get the following related resource data: `flow-actions`<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            fields_flow_action ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            fields_flow ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#relationships. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_flow_endpoint.call_with_http_info(**kwargs)

    def get_flow_action(
        self,
        id,
        **kwargs
    ):
        """Get Flow Action  # noqa: E501

        Get a flow action from a flow with the given flow action ID. Include parameters can be provided to get the following related resource data: `flows`, `flow-messages`<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_action(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            fields_flow_action ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            fields_flow_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            fields_flow ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#relationships. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_flow_action_endpoint.call_with_http_info(**kwargs)

    def get_flow_action_flow(
        self,
        action_id,
        **kwargs
    ):
        """Get Flow For Flow Action  # noqa: E501

        Get the flow associated with the given action ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_action_flow(action_id, async_req=True)
        >>> result = thread.get()

        Args:
            action_id (str): 

        Keyword Args:
            fields_flow ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['action_id'] = \
            action_id
        return self.get_flow_action_flow_endpoint.call_with_http_info(**kwargs)

    def get_flow_action_messages(
        self,
        action_id,
        **kwargs
    ):
        """Get Messages For Flow Action  # noqa: E501

        Get all flow messages associated with the given action ID. Flow messages can be sorted by the following fields, in ascending and descending order: `id`,  `name`, `created`, `updated` Use filters to narrow your results. Request specific fields using [sparse fieldsets](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#sparse-fieldsets). Returns a maximum of 50 flows per request, which can be paginated with [offset pagination](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#pagination). Offset pagination uses the following parameters: `page[size]` and `page[number]`<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_action_messages(action_id, async_req=True)
        >>> result = thread.get()

        Args:
            action_id (str): 

        Keyword Args:
            fields_flow_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            filter (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`id`: `any`<br>`name`: `contains`, `ends-with`, `equals`, `starts-with`<br>`created`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`. [optional]
            sort (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['action_id'] = \
            action_id
        return self.get_flow_action_messages_endpoint.call_with_http_info(**kwargs)

    def get_flow_action_relationships(
        self,
        id,
        related_resource,
        **kwargs
    ):
        """Get Flow Action Relationships  # noqa: E501

        Get all [relationships](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#relationships) for flow messages associated with the given flow action ID.  Flow message relationships can be sorted by the following fields, in ascending and descending order:  `id`,  `name`, `created`, `updated`  Use filters to narrow your results.  Returns a maximum of 50 flow message relationships per request, which can be paginated with [offset pagination](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#pagination). Offset pagination uses the following parameters: `page[size]` and `page[number]`<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_action_relationships(id, related_resource, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 
            related_resource (str): 

        Keyword Args:
            filter (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`name`: `contains`, `ends-with`, `equals`, `starts-with`<br>`created`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`. [optional]
            sort (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['related_resource'] = \
            related_resource
        return self.get_flow_action_relationships_endpoint.call_with_http_info(**kwargs)

    def get_flow_flow_actions(
        self,
        flow_id,
        **kwargs
    ):
        """Get Flow Actions For Flow  # noqa: E501

        Get all flow actions associated with the given flow ID. Flow actions can be sorted by the following fields, in ascending and descending order: `id`,  `status`, `created`, `updated`, `action_type` Use filters to narrow your results. Request specific fields using [sparse fieldsets](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#sparse-fieldsets). Returns a maximum of 50 flows per request, which can be paginated with [offset pagination](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#pagination). Offset pagination uses the following parameters: `page[size]` and `page[number]`<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_flow_actions(flow_id, async_req=True)
        >>> result = thread.get()

        Args:
            flow_id (str): 

        Keyword Args:
            fields_flow_action ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            filter (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`id`: `any`<br>`action_type`: `any`, `equals`<br>`status`: `equals`<br>`created`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`. [optional]
            sort (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['flow_id'] = \
            flow_id
        return self.get_flow_flow_actions_endpoint.call_with_http_info(**kwargs)

    def get_flow_message(
        self,
        id,
        **kwargs
    ):
        """Get Flow Message  # noqa: E501

        Get the flow message of a flow with the given message ID. Request specific fields using [sparse fieldsets](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#sparse-fieldsets). Include parameters can be provided to get the following related resource data: 'flow-actions'<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_message(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            fields_flow_action ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            fields_flow_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#relationships. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_flow_message_endpoint.call_with_http_info(**kwargs)

    def get_flow_message_action(
        self,
        message_id,
        **kwargs
    ):
        """Get Flow Action For Message  # noqa: E501

        Get the flow action for a flow message with the given message ID. Request specific fields using [sparse fieldsets](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#sparse-fieldsets).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_message_action(message_id, async_req=True)
        >>> result = thread.get()

        Args:
            message_id (str): 

        Keyword Args:
            fields_flow_action ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['message_id'] = \
            message_id
        return self.get_flow_message_action_endpoint.call_with_http_info(**kwargs)

    def get_flow_message_relationships(
        self,
        id,
        related_resource="flow-action",
        **kwargs
    ):
        """Get Flow Message Relationships  # noqa: E501

        Get the [relationship](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#relationships) for a flow message's flow action, given the flow ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_message_relationships(id, related_resource="flow-action", async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 
            related_resource (str): . defaults to "flow-action", must be one of ["flow-action"]

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['related_resource'] = \
            related_resource
        return self.get_flow_message_relationships_endpoint.call_with_http_info(**kwargs)

    def get_flow_relationships(
        self,
        id,
        related_resource="flow-actions",
        **kwargs
    ):
        """Get Flow Relationships  # noqa: E501

        Get all [relationships](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#relationships) for flow actions associated with the given flow ID. Flow action relationships can be sorted by the following fields, in ascending and descending order: `id`,  `status`, `created`, `updated` Use filters to narrow your results. Returns a maximum of 50 flow action relationships per request, which can be paginated with [offset pagination](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#pagination)<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_relationships(id, related_resource="flow-actions", async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 
            related_resource (str): . defaults to "flow-actions", must be one of ["flow-actions"]

        Keyword Args:
            filter (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`action_type`: `equals`<br>`status`: `equals`<br>`created`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`. [optional]
            sort (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['related_resource'] = \
            related_resource
        return self.get_flow_relationships_endpoint.call_with_http_info(**kwargs)

    def get_flows(
        self,
        **kwargs
    ):
        """Get Flows  # noqa: E501

        Get all flows in an account. Flows can be sorted by the following fields, in ascending and descending order: `id`, `name`, `status`, `trigger_type`, `created`, `updated` Use filters to narrow your results. Request specific fields using [sparse fieldsets](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#sparse-fieldsets). Include parameters can be provided to get the following related resource data: `flow-actions` Returns a maximum of 50 flows per request, which can be paginated with [offset pagination](https://developers.klaviyo.com/en/v2022-10-17/reference/api_overview#pagination)<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flows(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            fields_flow_action ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            fields_flow ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sparse-fieldsets. [optional]
            filter (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`id`: `any`<br>`name`: `contains`, `ends-with`, `equals`, `starts-with`<br>`status`: `equals`<br>`archived`: `equals`<br>`created`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated`: `equals`, `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`trigger_type`: `equals`. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#relationships. [optional]
            sort (str): For more information please visit https://developers.klaviyo.com/en/v2022-10-17/reference/api-overview#sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_flows_endpoint.call_with_http_info(**kwargs)

    def update_flow(
        self,
        id,
        flow_update_query,
        **kwargs
    ):
        """Update Flow Status  # noqa: E501

        Update the status of a flow with the given flow ID, and all actions in that flow.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `Flows Write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_flow(id, flow_update_query, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 
            flow_update_query (FlowUpdateQuery):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['flow_update_query'] = \
            flow_update_query
        return self.update_flow_endpoint.call_with_http_info(**kwargs)

