import { Construct } from 'constructs';
export interface PlonePDBOptions {
    /**
     * maxUnavailable specification
     * @default - none
     */
    readonly maxUnavailable?: number | string;
    /**
     * minAvailable specification.
     * default only set if maxUnavailable is not set.
     * @default 1
     */
    readonly minAvailable?: number | string;
    /**
     * Extra labels to associate with resources.
     * @default - none
     */
    readonly labels?: {
        [name: string]: string;
    };
}
export declare class PlonePDB extends Construct {
    constructor(scope: Construct, id: string, selectorLabel: {
        [name: string]: string;
    }, options: PlonePDBOptions);
}
