"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PloneDeployment = void 0;
// import { log } from 'console';
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-29");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
const pdb_1 = require("./pdb");
class PloneDeployment extends constructs_1.Construct {
    constructor(scope, id, options) {
        super(scope, id);
        const image = options.image ?? {};
        const replicas = options.replicas ?? 2;
        const label = { app: cdk8s_1.Names.toLabelValue(this) };
        const optionLabels = options.labels ?? {};
        const deploymentLabels = {
            'app.kubernetes.io/name': optionLabels['app.kubernetes.io/name'] + '-deployment',
            'app.kubernetes.io/component': optionLabels['app.kubernetes.io/component'] ?? '' + '-deployment',
        };
        const template_labels = {
            ...optionLabels,
            ...label,
            'app.kubernetes.io/part-of': 'plone',
            'app.kubernetes.io/managed-by': 'cdk8s-plone',
        };
        const kpEnv = options?.environment ?? new kplus.Env([], {});
        var env = [];
        for (const name in kpEnv.variables) {
            env.push({ name: name, value: kpEnv.variables[name].value, valueFrom: kpEnv.variables[name].valueFrom });
        }
        var envFrom = [];
        for (const idx in kpEnv.sources) {
            const source = kpEnv.sources[idx];
            envFrom.push(source._toKube());
        }
        var ploneContainerSpec = {
            name: id + '-container', // here the namespaced name shold be used, but how?
            image: image.image,
            imagePullPolicy: image.imagePullPolicy,
            env: env,
            envFrom: envFrom,
            resources: {
                limits: {
                    cpu: k8s.Quantity.fromString(options.limitCpu ?? '1000m'),
                    memory: k8s.Quantity.fromString(options.limitMemory ?? '1Gi'),
                },
                requests: {
                    cpu: k8s.Quantity.fromString(options.requestCpu ?? '200m'),
                    memory: k8s.Quantity.fromString(options.requestMemory ?? '300Mi'),
                },
            },
            livenessProbe: options.livenessProbe ?? undefined,
            readinessProbe: options.readinessProbe ?? undefined,
        };
        const deploymentOptions = {
            metadata: {
                labels: deploymentLabels,
            },
            spec: {
                replicas,
                selector: {
                    matchLabels: label,
                },
                template: {
                    metadata: { labels: template_labels },
                    spec: {
                        imagePullSecrets: (image.imagePullSecrets ?? []).map((name) => ({ name: name })),
                        containers: [
                            ploneContainerSpec,
                            ...options.sidecars ?? [],
                        ],
                    },
                },
            },
        };
        new k8s.KubeDeployment(this, 'deployment', deploymentOptions);
        if (options.pdb ?? false) {
            const pdbOptions = options.pdb ?? {};
            new pdb_1.PlonePDB(this, 'pdb', label, pdbOptions);
        }
    }
}
exports.PloneDeployment = PloneDeployment;
//# sourceMappingURL=data:application/json;base64,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