"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayToSageMakerEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-cdk/core");
/**
 * @summary The ApiGatewayToSageMakerEndpoint class.
 */
class ApiGatewayToSageMakerEndpoint extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the ApiGatewayToSageMakerEndpoint class.
     * @since 1.68.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Setup the API Gateway
        [this.apiGateway, this.apiGatewayCloudWatchRole, this.apiGatewayLogGroup] = defaults.GlobalRestApi(this, props.apiGatewayProps, props.logGroupProps);
        // Setup the API Gateway role
        if (props.apiGatewayExecutionRole !== undefined) {
            this.apiGatewayRole = props.apiGatewayExecutionRole;
        }
        else {
            this.apiGatewayRole = new iam.Role(this, 'api-gateway-role', {
                assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com')
            });
            // Setup the IAM policy for SageMaker endpoint
            const invokePolicy = new iam.Policy(this, 'InvokeEndpointPolicy', {
                statements: [
                    new iam.PolicyStatement({
                        actions: ['sagemaker:InvokeEndpoint'],
                        resources: [`arn:${core_1.Aws.PARTITION}:sagemaker:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:endpoint/${props.endpointName}`]
                    })
                ]
            });
            invokePolicy.attachToRole(this.apiGatewayRole);
        }
        // Setup request validation
        const requestValidator = this.apiGateway.addRequestValidator('request-validator', {
            requestValidatorName: 'request-param-validator',
            // Setting this property to true makes sure the following are validated:
            // - Required request parameters in the URI
            // - Query string
            // - Headers
            validateRequestParameters: true
        });
        // Setup method and integration responses
        const methodResponses = [
            { statusCode: '200' },
            { statusCode: '500' },
            { statusCode: '400' }
        ];
        const integResponses = [];
        if (props.responseMappingTemplate !== undefined) {
            integResponses.push({
                statusCode: '200',
                responseTemplates: { 'application/json': props.responseMappingTemplate }
            });
        }
        else {
            integResponses.push({ statusCode: '200' });
        }
        integResponses.push({ statusCode: '500', selectionPattern: '5\\d{2}' }, { statusCode: '400', selectionPattern: '4\\d{2}' });
        // The SageMaker integration can be added either at the root of the API (GET https://execute-api.amazonaws.com/{some-param}),
        // or as a sub-resource (GET https://execute-api.amazonaws.com/inference/{some-param}).
        // The following lines will make sure only the necessary resources are created.
        let apiResource = this.apiGateway.root;
        if (props.resourceName !== undefined) {
            apiResource = apiResource.addResource(props.resourceName);
        }
        apiResource = apiResource.addResource(props.resourcePath);
        // Setup API Gateway method
        defaults.addProxyMethodToApiResource({
            service: 'runtime.sagemaker',
            path: `endpoints/${props.endpointName}/invocations`,
            apiGatewayRole: this.apiGatewayRole,
            apiMethod: 'GET',
            apiResource,
            requestValidator,
            requestTemplate: props.requestMappingTemplate,
            awsIntegrationProps: {
                options: { integrationResponses: integResponses }
            },
            methodOptions: { methodResponses }
        });
    }
}
exports.ApiGatewayToSageMakerEndpoint = ApiGatewayToSageMakerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayToSageMakerEndpoint[_a] = { fqn: "@aws-solutions-constructs/aws-apigateway-sagemakerendpoint.ApiGatewayToSageMakerEndpoint", version: "1.126.0" };
//# sourceMappingURL=data:application/json;base64,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