"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.GlobalVariables = exports.ActionCategory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
var ActionCategory;
(function (ActionCategory) {
    ActionCategory["SOURCE"] = "Source";
    ActionCategory["BUILD"] = "Build";
    ActionCategory["TEST"] = "Test";
    ActionCategory["APPROVAL"] = "Approval";
    ActionCategory["DEPLOY"] = "Deploy";
    ActionCategory["INVOKE"] = "Invoke";
})(ActionCategory = exports.ActionCategory || (exports.ActionCategory = {}));
/**
 * The CodePipeline variables that are global, not bound to a specific action.
 *
 * This class defines a bunch of static fields that represent the different variables.
 * These can be used can be used in any action configuration.
 *
 * @stability stable
 */
class GlobalVariables {
}
exports.GlobalVariables = GlobalVariables;
_a = JSII_RTTI_SYMBOL_1;
GlobalVariables[_a] = { fqn: "@aws-cdk/aws-codepipeline.GlobalVariables", version: "1.103.0" };
/**
 * The identifier of the current pipeline execution.
 *
 * @stability stable
 */
GlobalVariables.executionId = '#{codepipeline.PipelineExecutionId}';
/**
 * Low-level class for generic CodePipeline Actions implementing the {@link IAction} interface.
 *
 * Contains some common logic that can be re-used by all {@link IAction} implementations.
 * If you're writing your own Action class,
 * feel free to extend this class.
 *
 * @stability stable
 */
class Action {
    /**
     * @stability stable
     */
    constructor() {
        this._variableReferenced = false;
        this._namespaceToken = core_1.Lazy.string({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this._actualNamespace === undefined) {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
                else {
                    return this._customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this._customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this._variableReferenced ? this._actualNamespace : undefined);
                }
            },
        });
    }
    /**
     * The simple properties of the Action, like its Owner, name, etc.
     *
     * Note that this accessor will be called before the {@link bind} callback.
     *
     * @stability stable
     */
    get actionProperties() {
        if (this.__actionProperties === undefined) {
            const actionProperties = this.providedActionProperties;
            this._customerProvidedNamespace = actionProperties.variablesNamespace;
            this.__actionProperties = {
                ...actionProperties,
                variablesNamespace: this._customerProvidedNamespace === undefined
                    ? this._namespaceToken
                    : this._customerProvidedNamespace,
            };
        }
        return this.__actionProperties;
    }
    /**
     * The callback invoked when this Action is added to a Pipeline.
     *
     * @stability stable
     */
    bind(scope, stage, options) {
        this.__pipeline = stage.pipeline;
        this.__stage = stage;
        this.__scope = scope;
        this._actualNamespace = this._customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this._customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    /**
     * Creates an Event that will be triggered whenever the state of this Action changes.
     *
     * @stability stable
     */
    onStateChange(name, target, options) {
        const rule = new events.Rule(this._scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this._pipeline.pipelineArn],
            detail: {
                stage: [this._stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    /**
     * @stability stable
     */
    variableExpression(variableName) {
        this._variableReferenced = true;
        return `#{${this._namespaceToken}.${variableName}}`;
    }
    get _pipeline() {
        if (this.__pipeline) {
            return this.__pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get _stage() {
        if (this.__stage) {
            return this.__stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get _scope() {
        if (this.__scope) {
            return this.__scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
_b = JSII_RTTI_SYMBOL_1;
Action[_b] = { fqn: "@aws-cdk/aws-codepipeline.Action", version: "1.103.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYWN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsOENBQThDO0FBRzlDLHdDQUFnRDs7OztBQU9oRCxJQUFZLGNBT1g7QUFQRCxXQUFZLGNBQWM7SUFDeEIsbUNBQWlCLENBQUE7SUFDakIsaUNBQWUsQ0FBQTtJQUNmLCtCQUFhLENBQUE7SUFDYix1Q0FBcUIsQ0FBQTtJQUNyQixtQ0FBaUIsQ0FBQTtJQUNqQixtQ0FBaUIsQ0FBQTtBQUNuQixDQUFDLEVBUFcsY0FBYyxHQUFkLHNCQUFjLEtBQWQsc0JBQWMsUUFPekI7Ozs7Ozs7OztBQXNCRCxNQUFhLGVBQWU7O0FBQTVCLDBDQUdDOzs7Ozs7OztBQUR3QiwyQkFBVyxHQUFHLHFDQUFxQyxDQUFDOzs7Ozs7Ozs7O0FBaU83RSxNQUFzQixNQUFNOzs7O0lBZ0IxQjtRQUZRLHdCQUFtQixHQUFHLEtBQUssQ0FBQztRQUdsQyxJQUFJLENBQUMsZUFBZSxHQUFHLFdBQUksQ0FBQyxNQUFNLENBQUM7WUFDakMsT0FBTyxFQUFFLEdBQUcsRUFBRTtnQkFDWix5REFBeUQ7Z0JBQ3pELElBQUksSUFBSSxDQUFDLGdCQUFnQixLQUFLLFNBQVMsRUFBRTtvQkFDdkMsTUFBTSxJQUFJLEtBQUssQ0FBQyx5Q0FBeUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsS0FBSzt3QkFDNUYsOENBQThDLENBQUMsQ0FBQztpQkFDbkQ7cUJBQU07b0JBQ0wsT0FBTyxJQUFJLENBQUMsMEJBQTBCLEtBQUssU0FBUzt3QkFDbEQsK0RBQStEO3dCQUMvRCxDQUFDLENBQUMsSUFBSSxDQUFDLDBCQUEwQjt3QkFDakMsb0VBQW9FO3dCQUNwRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7aUJBQ3BFO1lBQ0gsQ0FBQztTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7Ozs7Ozs7O0lBRUQsSUFBVyxnQkFBZ0I7UUFDekIsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEtBQUssU0FBUyxFQUFFO1lBQ3pDLE1BQU0sZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLHdCQUF3QixDQUFDO1lBQ3ZELElBQUksQ0FBQywwQkFBMEIsR0FBRyxnQkFBZ0IsQ0FBQyxrQkFBa0IsQ0FBQztZQUN0RSxJQUFJLENBQUMsa0JBQWtCLEdBQUc7Z0JBQ3hCLEdBQUcsZ0JBQWdCO2dCQUNuQixrQkFBa0IsRUFBRSxJQUFJLENBQUMsMEJBQTBCLEtBQUssU0FBUztvQkFDL0QsQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlO29CQUN0QixDQUFDLENBQUMsSUFBSSxDQUFDLDBCQUEwQjthQUNwQyxDQUFDO1NBQ0g7UUFDRCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDOzs7Ozs7SUFFTSxJQUFJLENBQUMsS0FBZ0IsRUFBRSxLQUFhLEVBQUUsT0FBMEI7UUFDckUsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1FBQ3JCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1FBRXJCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsMEJBQTBCLEtBQUssU0FBUztZQUNuRSxnRUFBZ0U7WUFDaEUsQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxLQUFLO1lBQzdELENBQUMsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7UUFFcEMsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7Ozs7O0lBRU0sYUFBYSxDQUFDLElBQVksRUFBRSxNQUEyQixFQUFFLE9BQTBCO1FBQ3hGLE1BQU0sSUFBSSxHQUFHLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztRQUN6RCxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDbkIsVUFBVSxFQUFFLENBQUMsNENBQTRDLENBQUM7WUFDMUQsTUFBTSxFQUFFLENBQUMsa0JBQWtCLENBQUM7WUFDNUIsU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUM7WUFDdkMsTUFBTSxFQUFFO2dCQUNOLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDO2dCQUM5QixNQUFNLEVBQUUsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxDQUFDO2FBQzNDO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7O0lBRVMsa0JBQWtCLENBQUMsWUFBb0I7UUFDL0MsSUFBSSxDQUFDLG1CQUFtQixHQUFHLElBQUksQ0FBQztRQUNoQyxPQUFPLEtBQUssSUFBSSxDQUFDLGVBQWUsSUFBSSxZQUFZLEdBQUcsQ0FBQztJQUN0RCxDQUFDO0lBT0QsSUFBWSxTQUFTO1FBQ25CLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUNuQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7U0FDeEI7YUFBTTtZQUNMLE1BQU0sSUFBSSxLQUFLLENBQUMsdUZBQXVGLENBQUMsQ0FBQztTQUMxRztJQUNILENBQUM7SUFFRCxJQUFZLE1BQU07UUFDaEIsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ2hCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUNyQjthQUFNO1lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQyx1RkFBdUYsQ0FBQyxDQUFDO1NBQzFHO0lBQ0gsQ0FBQztJQUVEOzs7O09BSUc7SUFDSCxJQUFZLE1BQU07UUFDaEIsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ2hCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUNyQjthQUFNO1lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQyxrRUFBa0UsQ0FBQyxDQUFDO1NBQ3JGO0lBQ0gsQ0FBQzs7QUFqSEgsd0JBa0hDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZXZlbnRzIGZyb20gJ0Bhd3MtY2RrL2F3cy1ldmVudHMnO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgczMgZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcbmltcG9ydCB7IElSZXNvdXJjZSwgTGF6eSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQXJ0aWZhY3QgfSBmcm9tICcuL2FydGlmYWN0JztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5leHBvcnQgZW51bSBBY3Rpb25DYXRlZ29yeSB7XG4gIFNPVVJDRSA9ICdTb3VyY2UnLFxuICBCVUlMRCA9ICdCdWlsZCcsXG4gIFRFU1QgPSAnVGVzdCcsXG4gIEFQUFJPVkFMID0gJ0FwcHJvdmFsJyxcbiAgREVQTE9ZID0gJ0RlcGxveScsXG4gIElOVk9LRSA9ICdJbnZva2UnXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBBY3Rpb25BcnRpZmFjdEJvdW5kcyB7XG4gIHJlYWRvbmx5IG1pbklucHV0czogbnVtYmVyO1xuICByZWFkb25seSBtYXhJbnB1dHM6IG51bWJlcjtcbiAgcmVhZG9ubHkgbWluT3V0cHV0czogbnVtYmVyO1xuICByZWFkb25seSBtYXhPdXRwdXRzOiBudW1iZXI7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBHbG9iYWxWYXJpYWJsZXMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IGV4ZWN1dGlvbklkID0gJyN7Y29kZXBpcGVsaW5lLlBpcGVsaW5lRXhlY3V0aW9uSWR9Jztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBY3Rpb25Qcm9wZXJ0aWVzIHtcbiAgcmVhZG9ubHkgYWN0aW9uTmFtZTogc3RyaW5nO1xuICByZWFkb25seSByb2xlPzogaWFtLklSb2xlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYWNjb3VudD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVzb3VyY2U/OiBJUmVzb3VyY2U7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2F0ZWdvcnk6IEFjdGlvbkNhdGVnb3J5O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJvdmlkZXI6IHN0cmluZztcbiAgcmVhZG9ubHkgb3duZXI/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHZlcnNpb24/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcnVuT3JkZXI/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGFydGlmYWN0Qm91bmRzOiBBY3Rpb25BcnRpZmFjdEJvdW5kcztcbiAgcmVhZG9ubHkgaW5wdXRzPzogQXJ0aWZhY3RbXTtcbiAgcmVhZG9ubHkgb3V0cHV0cz86IEFydGlmYWN0W107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZhcmlhYmxlc05hbWVzcGFjZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBY3Rpb25CaW5kT3B0aW9ucyB7XG4gIHJlYWRvbmx5IHJvbGU6IGlhbS5JUm9sZTtcblxuICByZWFkb25seSBidWNrZXQ6IHMzLklCdWNrZXQ7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQWN0aW9uQ29uZmlnIHtcbiAgcmVhZG9ubHkgY29uZmlndXJhdGlvbj86IGFueTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUFjdGlvbiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFjdGlvblByb3BlcnRpZXM6IEFjdGlvblByb3BlcnRpZXM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QsIHN0YWdlOiBJU3RhZ2UsIG9wdGlvbnM6IEFjdGlvbkJpbmRPcHRpb25zKTogQWN0aW9uQ29uZmlnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIG9uU3RhdGVDaGFuZ2UobmFtZTogc3RyaW5nLCB0YXJnZXQ/OiBldmVudHMuSVJ1bGVUYXJnZXQsIG9wdGlvbnM/OiBldmVudHMuUnVsZVByb3BzKTogZXZlbnRzLlJ1bGU7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIElQaXBlbGluZSBleHRlbmRzIElSZXNvdXJjZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcGlwZWxpbmVOYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHBpcGVsaW5lQXJuOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgb25FdmVudChpZDogc3RyaW5nLCBvcHRpb25zPzogZXZlbnRzLk9uRXZlbnRPcHRpb25zKTogZXZlbnRzLlJ1bGU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBvblN0YXRlQ2hhbmdlKGlkOiBzdHJpbmcsIG9wdGlvbnM/OiBldmVudHMuT25FdmVudE9wdGlvbnMpOiBldmVudHMuUnVsZTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIElTdGFnZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdGFnZU5hbWU6IHN0cmluZztcblxuICByZWFkb25seSBwaXBlbGluZTogSVBpcGVsaW5lO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhY3Rpb25zOiBJQWN0aW9uW107XG5cbiAgYWRkQWN0aW9uKGFjdGlvbjogSUFjdGlvbik6IHZvaWQ7XG5cbiAgb25TdGF0ZUNoYW5nZShuYW1lOiBzdHJpbmcsIHRhcmdldD86IGV2ZW50cy5JUnVsZVRhcmdldCwgb3B0aW9ucz86IGV2ZW50cy5SdWxlUHJvcHMpOiBldmVudHMuUnVsZTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIENvbW1vbkFjdGlvblByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFjdGlvbk5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcnVuT3JkZXI/OiBudW1iZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZhcmlhYmxlc05hbWVzcGFjZT86IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBDb21tb25Bd3NBY3Rpb25Qcm9wcyBleHRlbmRzIENvbW1vbkFjdGlvblByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByb2xlPzogaWFtLklSb2xlO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEFjdGlvbiBpbXBsZW1lbnRzIElBY3Rpb24ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHJvdGVjdGVkIGFic3RyYWN0IHJlYWRvbmx5IHByb3ZpZGVkQWN0aW9uUHJvcGVydGllczogQWN0aW9uUHJvcGVydGllcztcblxuICBwcml2YXRlIF9fYWN0aW9uUHJvcGVydGllcz86IEFjdGlvblByb3BlcnRpZXM7XG4gIHByaXZhdGUgX19waXBlbGluZT86IElQaXBlbGluZTtcbiAgcHJpdmF0ZSBfX3N0YWdlPzogSVN0YWdlO1xuICBwcml2YXRlIF9fc2NvcGU/OiBDb25zdHJ1Y3Q7XG4gIHByaXZhdGUgcmVhZG9ubHkgX25hbWVzcGFjZVRva2VuOiBzdHJpbmc7XG4gIHByaXZhdGUgX2N1c3RvbWVyUHJvdmlkZWROYW1lc3BhY2U/OiBzdHJpbmc7XG4gIHByaXZhdGUgX2FjdHVhbE5hbWVzcGFjZT86IHN0cmluZztcblxuICBwcml2YXRlIF92YXJpYWJsZVJlZmVyZW5jZWQgPSBmYWxzZTtcblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IoKSB7XG4gICAgdGhpcy5fbmFtZXNwYWNlVG9rZW4gPSBMYXp5LnN0cmluZyh7XG4gICAgICBwcm9kdWNlOiAoKSA9PiB7XG4gICAgICAgIC8vIG1ha2Ugc3VyZSB0aGUgYWN0aW9uIHdhcyBib3VuZCAoPSBhZGRlZCB0byBhIHBpcGVsaW5lKVxuICAgICAgICBpZiAodGhpcy5fYWN0dWFsTmFtZXNwYWNlID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYENhbm5vdCByZWZlcmVuY2UgdmFyaWFibGVzIG9mIGFjdGlvbiAnJHt0aGlzLmFjdGlvblByb3BlcnRpZXMuYWN0aW9uTmFtZX0nLCBgICtcbiAgICAgICAgICAgICdhcyB0aGF0IGFjdGlvbiB3YXMgbmV2ZXIgYWRkZWQgdG8gYSBwaXBlbGluZScpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHJldHVybiB0aGlzLl9jdXN0b21lclByb3ZpZGVkTmFtZXNwYWNlICE9PSB1bmRlZmluZWRcbiAgICAgICAgICAgIC8vIGlmIGEgY3VzdG9tZXIgcGFzc2VkIGEgbmFtZXNwYWNlIGV4cGxpY2l0bHksIGFsd2F5cyB1c2UgdGhhdFxuICAgICAgICAgICAgPyB0aGlzLl9jdXN0b21lclByb3ZpZGVkTmFtZXNwYWNlXG4gICAgICAgICAgICAvLyBvdGhlcndpc2UsIG9ubHkgcmV0dXJuIGEgbmFtZXNwYWNlIGlmIGFueSB2YXJpYWJsZSB3YXMgcmVmZXJlbmNlZFxuICAgICAgICAgICAgOiAodGhpcy5fdmFyaWFibGVSZWZlcmVuY2VkID8gdGhpcy5fYWN0dWFsTmFtZXNwYWNlIDogdW5kZWZpbmVkKTtcbiAgICAgICAgfVxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgYWN0aW9uUHJvcGVydGllcygpOiBBY3Rpb25Qcm9wZXJ0aWVzIHtcbiAgICBpZiAodGhpcy5fX2FjdGlvblByb3BlcnRpZXMgPT09IHVuZGVmaW5lZCkge1xuICAgICAgY29uc3QgYWN0aW9uUHJvcGVydGllcyA9IHRoaXMucHJvdmlkZWRBY3Rpb25Qcm9wZXJ0aWVzO1xuICAgICAgdGhpcy5fY3VzdG9tZXJQcm92aWRlZE5hbWVzcGFjZSA9IGFjdGlvblByb3BlcnRpZXMudmFyaWFibGVzTmFtZXNwYWNlO1xuICAgICAgdGhpcy5fX2FjdGlvblByb3BlcnRpZXMgPSB7XG4gICAgICAgIC4uLmFjdGlvblByb3BlcnRpZXMsXG4gICAgICAgIHZhcmlhYmxlc05hbWVzcGFjZTogdGhpcy5fY3VzdG9tZXJQcm92aWRlZE5hbWVzcGFjZSA9PT0gdW5kZWZpbmVkXG4gICAgICAgICAgPyB0aGlzLl9uYW1lc3BhY2VUb2tlblxuICAgICAgICAgIDogdGhpcy5fY3VzdG9tZXJQcm92aWRlZE5hbWVzcGFjZSxcbiAgICAgIH07XG4gICAgfVxuICAgIHJldHVybiB0aGlzLl9fYWN0aW9uUHJvcGVydGllcztcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QsIHN0YWdlOiBJU3RhZ2UsIG9wdGlvbnM6IEFjdGlvbkJpbmRPcHRpb25zKTogQWN0aW9uQ29uZmlnIHtcbiAgICB0aGlzLl9fcGlwZWxpbmUgPSBzdGFnZS5waXBlbGluZTtcbiAgICB0aGlzLl9fc3RhZ2UgPSBzdGFnZTtcbiAgICB0aGlzLl9fc2NvcGUgPSBzY29wZTtcblxuICAgIHRoaXMuX2FjdHVhbE5hbWVzcGFjZSA9IHRoaXMuX2N1c3RvbWVyUHJvdmlkZWROYW1lc3BhY2UgPT09IHVuZGVmaW5lZFxuICAgICAgLy8gZGVmYXVsdCBhIG5hbWVzcGFjZSBuYW1lLCBiYXNlZCBvbiB0aGUgc3RhZ2UgYW5kIGFjdGlvbiBuYW1lc1xuICAgICAgPyBgJHtzdGFnZS5zdGFnZU5hbWV9XyR7dGhpcy5hY3Rpb25Qcm9wZXJ0aWVzLmFjdGlvbk5hbWV9X05TYFxuICAgICAgOiB0aGlzLl9jdXN0b21lclByb3ZpZGVkTmFtZXNwYWNlO1xuXG4gICAgcmV0dXJuIHRoaXMuYm91bmQoc2NvcGUsIHN0YWdlLCBvcHRpb25zKTtcbiAgfVxuXG4gIHB1YmxpYyBvblN0YXRlQ2hhbmdlKG5hbWU6IHN0cmluZywgdGFyZ2V0PzogZXZlbnRzLklSdWxlVGFyZ2V0LCBvcHRpb25zPzogZXZlbnRzLlJ1bGVQcm9wcykge1xuICAgIGNvbnN0IHJ1bGUgPSBuZXcgZXZlbnRzLlJ1bGUodGhpcy5fc2NvcGUsIG5hbWUsIG9wdGlvbnMpO1xuICAgIHJ1bGUuYWRkVGFyZ2V0KHRhcmdldCk7XG4gICAgcnVsZS5hZGRFdmVudFBhdHRlcm4oe1xuICAgICAgZGV0YWlsVHlwZTogWydDb2RlUGlwZWxpbmUgQWN0aW9uIEV4ZWN1dGlvbiBTdGF0ZSBDaGFuZ2UnXSxcbiAgICAgIHNvdXJjZTogWydhd3MuY29kZXBpcGVsaW5lJ10sXG4gICAgICByZXNvdXJjZXM6IFt0aGlzLl9waXBlbGluZS5waXBlbGluZUFybl0sXG4gICAgICBkZXRhaWw6IHtcbiAgICAgICAgc3RhZ2U6IFt0aGlzLl9zdGFnZS5zdGFnZU5hbWVdLFxuICAgICAgICBhY3Rpb246IFt0aGlzLmFjdGlvblByb3BlcnRpZXMuYWN0aW9uTmFtZV0sXG4gICAgICB9LFxuICAgIH0pO1xuICAgIHJldHVybiBydWxlO1xuICB9XG5cbiAgcHJvdGVjdGVkIHZhcmlhYmxlRXhwcmVzc2lvbih2YXJpYWJsZU5hbWU6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgdGhpcy5fdmFyaWFibGVSZWZlcmVuY2VkID0gdHJ1ZTtcbiAgICByZXR1cm4gYCN7JHt0aGlzLl9uYW1lc3BhY2VUb2tlbn0uJHt2YXJpYWJsZU5hbWV9fWA7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHByb3RlY3RlZCBhYnN0cmFjdCBib3VuZChzY29wZTogQ29uc3RydWN0LCBzdGFnZTogSVN0YWdlLCBvcHRpb25zOiBBY3Rpb25CaW5kT3B0aW9ucyk6IEFjdGlvbkNvbmZpZztcblxuICBwcml2YXRlIGdldCBfcGlwZWxpbmUoKTogSVBpcGVsaW5lIHtcbiAgICBpZiAodGhpcy5fX3BpcGVsaW5lKSB7XG4gICAgICByZXR1cm4gdGhpcy5fX3BpcGVsaW5lO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0FjdGlvbiBtdXN0IGJlIGFkZGVkIHRvIGEgc3RhZ2UgdGhhdCBpcyBwYXJ0IG9mIGEgcGlwZWxpbmUgYmVmb3JlIHVzaW5nIG9uU3RhdGVDaGFuZ2UnKTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGdldCBfc3RhZ2UoKTogSVN0YWdlIHtcbiAgICBpZiAodGhpcy5fX3N0YWdlKSB7XG4gICAgICByZXR1cm4gdGhpcy5fX3N0YWdlO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0FjdGlvbiBtdXN0IGJlIGFkZGVkIHRvIGEgc3RhZ2UgdGhhdCBpcyBwYXJ0IG9mIGEgcGlwZWxpbmUgYmVmb3JlIHVzaW5nIG9uU3RhdGVDaGFuZ2UnKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogUmV0cmlldmVzIHRoZSBDb25zdHJ1Y3Qgc2NvcGUgb2YgdGhpcyBBY3Rpb24uXG4gICAqIE9ubHkgYXZhaWxhYmxlIGFmdGVyIHRoZSBBY3Rpb24gaGFzIGJlZW4gYWRkZWQgdG8gYSBTdGFnZSxcbiAgICogYW5kIHRoYXQgU3RhZ2UgdG8gYSBQaXBlbGluZS5cbiAgICovXG4gIHByaXZhdGUgZ2V0IF9zY29wZSgpOiBDb25zdHJ1Y3Qge1xuICAgIGlmICh0aGlzLl9fc2NvcGUpIHtcbiAgICAgIHJldHVybiB0aGlzLl9fc2NvcGU7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQWN0aW9uIG11c3QgYmUgYWRkZWQgdG8gYSBzdGFnZSB0aGF0IGlzIHBhcnQgb2YgYSBwaXBlbGluZSBmaXJzdCcpO1xuICAgIH1cbiAgfVxufVxuIl19