//! Test data for extension system testing with real-world DDEX examples

/// Real-world DDEX XML with Spotify extensions
pub const DDEX_WITH_SPOTIFY_EXTENSIONS: &str = r#"<?xml version="1.0" encoding="UTF-8"?>
<!--Generated by Spotify DDEX System-->
<ern:NewReleaseMessage xmlns:ern="http://ddex.net/xml/ern/43" xmlns:spotify="http://spotify.com/ddex/extensions">
  <MessageHeader>
    <MessageId>SPOTIFY_DDEX_20241201_001</MessageId>
    <MessageSender>
      <PartyName>Spotify AB</PartyName>
      <spotify:SpotifyMetadata>
        <spotify:IngestingTeam>Content Operations</spotify:IngestingTeam>
        <spotify:Priority>High</spotify:Priority>
        <spotify:InternalNotes>Priority release for featured artist</spotify:InternalNotes>
      </spotify:SpotifyMetadata>
    </MessageSender>
    <MessageRecipient>
      <PartyName>Universal Music Group</PartyName>
    </MessageRecipient>
    <MessageCreatedDateTime>2024-12-01T10:30:00Z</MessageCreatedDateTime>
  </MessageHeader>
  <ReleaseList>
    <Release>
      <ReleaseId>
        <ISRC>GBUM71507609</ISRC>
        <ProprietaryId>UMG_REL_2024_001</ProprietaryId>
        <spotify:SpotifyAlbumId>1a2b3c4d5e6f7g8h9i0j</spotify:SpotifyAlbumId>
      </ReleaseId>
      <ReleaseReference>R1</ReleaseReference>
      <ReferenceTitle>
        <TitleText>Amazing Album</TitleText>
        <SubTitle>Deluxe Edition</SubTitle>
      </ReferenceTitle>
      <spotify:ReleaseMetadata>
        <spotify:PlaylistEligible>true</spotify:PlaylistEligible>
        <spotify:GenrePreferences>
          <spotify:Genre weight="0.8">pop</spotify:Genre>
          <spotify:Genre weight="0.2">electronic</spotify:Genre>
        </spotify:GenrePreferences>
        <spotify:MarketingFlags>
          <spotify:Flag type="editorial">featured</spotify:Flag>
          <spotify:Flag type="algorithmic">boost</spotify:Flag>
        </spotify:MarketingFlags>
      </spotify:ReleaseMetadata>
      <ReleaseResourceReferenceList>
        <ReleaseResourceReference>
          <A1>Track01</A1>
        </ReleaseResourceReference>
      </ReleaseResourceReferenceList>
    </Release>
  </ReleaseList>
  <ResourceList>
    <SoundRecording>
      <ResourceReference>Track01</ResourceReference>
      <ReferenceTitle>
        <TitleText>Hit Single</TitleText>
      </ReferenceTitle>
      <SoundRecordingId>
        <ISRC>GBUM71507610</ISRC>
        <spotify:SpotifyTrackId>0z1y2x3w4v5u6t7s8r9q</spotify:SpotifyTrackId>
      </SoundRecordingId>
      <spotify:TrackMetadata>
        <spotify:AudioFeatures>
          <spotify:Danceability>0.742</spotify:Danceability>
          <spotify:Energy>0.856</spotify:Energy>
          <spotify:Valence>0.632</spotify:Valence>
          <spotify:Tempo>128.5</spotify:Tempo>
        </spotify:AudioFeatures>
        <spotify:ContentTags>
          <spotify:Tag>explicit-lyrics</spotify:Tag>
          <spotify:Tag>radio-edit</spotify:Tag>
        </spotify:ContentTags>
      </spotify:TrackMetadata>
      <DisplayArtist>
        <PartyName>
          <FullName>Amazing Artist</FullName>
        </PartyName>
      </DisplayArtist>
    </SoundRecording>
  </ResourceList>
</ern:NewReleaseMessage>"#;

/// DDEX XML with YouTube Music extensions
pub const DDEX_WITH_YOUTUBE_EXTENSIONS: &str = r#"<?xml version="1.0" encoding="UTF-8"?>
<?youtube-processing-instruction version="2.1" priority="high"?>
<ern:NewReleaseMessage xmlns:ern="http://ddex.net/xml/ern/43" xmlns:ytm="http://youtube.com/music/ddex">
  <MessageHeader>
    <MessageId>YTM_DELIVERY_20241201_002</MessageId>
    <MessageSender>
      <PartyName>YouTube Music</PartyName>
      <ytm:DeliveryMetadata>
        <ytm:DeliveryChannel>automated</ytm:DeliveryChannel>
        <ytm:ProcessingQueue>priority</ytm:ProcessingQueue>
        <ytm:RetryPolicy>
          <ytm:MaxRetries>3</ytm:MaxRetries>
          <ytm:BackoffStrategy>exponential</ytm:BackoffStrategy>
        </ytm:RetryPolicy>
      </ytm:DeliveryMetadata>
    </MessageSender>
    <MessageRecipient>
      <PartyName>Sony Music Entertainment</PartyName>
    </MessageRecipient>
    <MessageCreatedDateTime>2024-12-01T11:15:00Z</MessageCreatedDateTime>
  </MessageHeader>
  <ReleaseList>
    <Release>
      <ReleaseId>
        <ISRC>USSM11900123</USSM11900123>
        <ProprietaryId>SONY_REL_2024_456</ProprietaryId>
        <ytm:YouTubeMusicAlbumId>PLrAKsdTkSIRQp-HIyx</ytm:YouTubeMusicAlbumId>
      </ReleaseId>
      <ReleaseReference>R2</ReleaseReference>
      <ReferenceTitle>
        <TitleText>Viral Hits Collection</TitleText>
      </ReferenceTitle>
      <ytm:VideoMetadata>
        <ytm:ContentCategory>Music</ytm:ContentCategory>
        <ytm:Monetization enabled="true">
          <ytm:AdFormats>
            <ytm:Format>pre-roll</ytm:Format>
            <ytm:Format>mid-roll</ytm:Format>
          </ytm:AdFormats>
        </ytm:Monetization>
        <ytm:Analytics>
          <ytm:TrackViews>true</ytm:TrackViews>
          <ytm:TrackEngagement>true</ytm:TrackEngagement>
        </ytm:Analytics>
      </ytm:VideoMetadata>
    </Release>
  </ReleaseList>
  <ResourceList>
    <SoundRecording>
      <ResourceReference>Track02</ResourceReference>
      <ReferenceTitle>
        <TitleText>Trending Song</TitleText>
      </ReferenceTitle>
      <SoundRecordingId>
        <ISRC>USSM11900124</ISRC>
        <ytm:YouTubeVideoId>dQw4w9WgXcQ</ytm:YouTubeVideoId>
      </SoundRecordingId>
      <ytm:ContentMetadata>
        <ytm:MusicVideo available="true">
          <ytm:Resolution>4K</ytm:Resolution>
          <ytm:AspectRatio>16:9</ytm:AspectRatio>
        </ytm:MusicVideo>
        <ytm:Lyrics>
          <ytm:Type>synchronized</ytm:Type>
          <ytm:Language>en</ytm:Language>
          <ytm:Source>official</ytm:Source>
        </ytm:Lyrics>
        <ytm:RecommendationTags>
          <ytm:Tag category="mood">upbeat</ytm:Tag>
          <ytm:Tag category="activity">workout</ytm:Tag>
        </ytm:RecommendationTags>
      </ytm:ContentMetadata>
      <DisplayArtist>
        <PartyName>
          <FullName>Viral Artist</FullName>
        </PartyName>
      </DisplayArtist>
    </SoundRecording>
  </ResourceList>
</ern:NewReleaseMessage>"#;

/// DDEX XML with Apple Music extensions
pub const DDEX_WITH_APPLE_EXTENSIONS: &str = r#"<?xml version="1.0" encoding="UTF-8"?>
<!--Apple Music Content Ingestion System v3.2-->
<ern:NewReleaseMessage xmlns:ern="http://ddex.net/xml/ern/43" xmlns:apple="http://apple.com/itunes/ddex">
  <MessageHeader>
    <MessageId>APPLE_INGESTION_20241201_003</MessageId>
    <MessageSender>
      <PartyName>Apple Inc.</PartyName>
    </MessageSender>
    <MessageRecipient>
      <PartyName>Warner Music Group</PartyName>
      <apple:DistributorMetadata>
        <apple:TerritoryManager>EMEA</apple:TerritoryManager>
        <apple:ContentTier>Premium</apple:ContentTier>
        <apple:ProcessingPreferences>
          <apple:QualityCheck>strict</apple:QualityCheck>
          <apple:MetadataValidation>enhanced</apple:MetadataValidation>
        </apple:ProcessingPreferences>
      </apple:DistributorMetadata>
    </MessageRecipient>
    <MessageCreatedDateTime>2024-12-01T12:00:00Z</MessageCreatedDateTime>
  </MessageHeader>
  <ReleaseList>
    <Release>
      <ReleaseId>
        <ISRC>GBF077700123</ISRC>
        <ProprietaryId>WMG_REL_2024_789</ProprietaryId>
        <apple:iTunesId>1234567890</apple:iTunesId>
      </ReleaseId>
      <ReleaseReference>R3</ReleaseReference>
      <ReferenceTitle>
        <TitleText>Spatial Audio Masterpiece</TitleText>
      </ReferenceTitle>
      <apple:ReleaseEnhancements>
        <apple:SpatialAudio>
          <apple:Available>true</apple:Available>
          <apple:Format>Dolby Atmos</apple:Format>
          <apple:BitrateKbps>1411</apple:BitrateKbps>
        </apple:SpatialAudio>
        <apple:LosslessAudio>
          <apple:Available>true</apple:Available>
          <apple:Format>ALAC</apple:Format>
          <apple:BitDepth>24</apple:BitDepth>
          <apple:SampleRate>96000</apple:SampleRate>
        </apple:LosslessAudio>
        <apple:AnimatedArtwork>
          <apple:Available>true</apple:Available>
          <apple:Duration>PT15S</apple:Duration>
        </apple:AnimatedArtwork>
      </apple:ReleaseEnhancements>
    </Release>
  </ReleaseList>
  <ResourceList>
    <SoundRecording>
      <ResourceReference>Track03</ResourceReference>
      <ReferenceTitle>
        <TitleText>Immersive Experience</TitleText>
      </ReferenceTitle>
      <SoundRecordingId>
        <ISRC>GBF077700124</ISRC>
        <apple:iTunesTrackId>987654321</apple:iTunesTrackId>
      </SoundRecordingId>
      <apple:TrackEnhancements>
        <apple:Mastering>
          <apple:MasteredFor>iTunes</apple:MasteredFor>
          <apple:LoudnessLUFS>-16.0</apple:LoudnessLUFS>
          <apple:TruePeak>-1.0</apple:TruePeak>
        </apple:Mastering>
        <apple:Lyrics>
          <apple:Type>time-synced</apple:Type>
          <apple:Provider>LyricFind</apple:Provider>
          <apple:Karaoke>available</apple:Karaoke>
        </apple:Lyrics>
      </apple:TrackEnhancements>
      <DisplayArtist>
        <PartyName>
          <FullName>Immersive Artist</FullName>
        </PartyName>
      </DisplayArtist>
    </SoundRecording>
  </ResourceList>
</ern:NewReleaseMessage>"#;

/// DDEX XML with multiple proprietary extensions (complex example)
pub const DDEX_WITH_MULTIPLE_EXTENSIONS: &str = r#"<?xml version="1.0" encoding="UTF-8"?>
<?custom-processing version="1.0" system="multi-platform"?>
<!--Multi-platform distribution system-->
<ern:NewReleaseMessage xmlns:ern="http://ddex.net/xml/ern/43" 
                       xmlns:analytics="http://example.com/analytics" 
                       xmlns:blockchain="http://example.com/blockchain"
                       xmlns:ml="http://example.com/machine-learning">
  <MessageHeader>
    <MessageId>MULTI_PLATFORM_20241201_004</MessageId>
    <MessageSender>
      <PartyName>Distribution Hub</PartyName>
      <analytics:TrackingMetadata>
        <analytics:SessionId>sess_abc123def456</analytics:SessionId>
        <analytics:UserId>user_789xyz</analytics:UserId>
        <analytics:Platform>web</analytics:Platform>
        <analytics:Version>2.4.1</analytics:Version>
      </analytics:TrackingMetadata>
    </MessageSender>
    <MessageRecipient>
      <PartyName>Independent Label</PartyName>
    </MessageRecipient>
    <MessageCreatedDateTime>2024-12-01T13:45:00Z</MessageCreatedDateTime>
    <blockchain:Rights>
      <blockchain:SmartContract>0x1234567890abcdef</blockchain:SmartContract>
      <blockchain:Network>ethereum</blockchain:Network>
      <blockchain:TokenStandard>ERC-721</blockchain:TokenStandard>
    </blockchain:Rights>
  </MessageHeader>
  <ReleaseList>
    <Release>
      <ReleaseId>
        <ISRC>INDIE12300456</ISRC>
        <ProprietaryId>INDIE_REL_2024_101</ProprietaryId>
        <blockchain:NFTTokenId>42</blockchain:NFTTokenId>
      </ReleaseId>
      <ReleaseReference>R4</ReleaseReference>
      <ReferenceTitle>
        <TitleText>AI-Generated Masterpiece</TitleText>
      </ReferenceTitle>
      <ml:GenerationMetadata>
        <ml:Model>
          <ml:Name>MusicGPT-Ultra</ml:Name>
          <ml:Version>3.5</ml:Version>
          <ml:TrainingDate>2024-11-01</ml:TrainingDate>
        </ml:Model>
        <ml:CreationProcess>
          <ml:Prompt>Create an uplifting electronic track with orchestral elements</ml:Prompt>
          <ml:Seed>987654321</ml:Seed>
          <ml:Temperature>0.7</ml:Temperature>
          <ml:Iterations>50</ml:Iterations>
        </ml:CreationProcess>
        <ml:HumanContribution>
          <ml:Percentage>25</ml:Percentage>
          <ml:Aspects>
            <ml:Aspect>lyrics</ml:Aspect>
            <ml:Aspect>final-arrangement</ml:Aspect>
          </ml:Aspects>
        </ml:HumanContribution>
      </ml:GenerationMetadata>
      <blockchain:Ownership>
        <blockchain:Splits>
          <blockchain:Split beneficiary="artist" percentage="60.0"/>
          <blockchain:Split beneficiary="producer" percentage="25.0"/>
          <blockchain:Split beneficiary="label" percentage="15.0"/>
        </blockchain:Splits>
      </blockchain:Ownership>
    </Release>
  </ReleaseList>
  <ResourceList>
    <SoundRecording>
      <ResourceReference>Track04</ResourceReference>
      <ReferenceTitle>
        <TitleText>Digital Symphony</TitleText>
      </ReferenceTitle>
      <SoundRecordingId>
        <ISRC>INDIE12300457</ISRC>
        <blockchain:AssetHash>QmX1Y2Z3...</blockchain:AssetHash>
      </SoundRecordingId>
      <analytics:Performance>
        <analytics:PredictedStreams>
          <analytics:Platform name="spotify">1250000</analytics:Platform>
          <analytics:Platform name="apple">850000</analytics:Platform>
          <analytics:Platform name="youtube">2100000</analytics:Platform>
        </analytics:PredictedStreams>
        <analytics:Demographics>
          <analytics:AgeGroup range="18-24" percentage="35"/>
          <analytics:AgeGroup range="25-34" percentage="42"/>
          <analytics:AgeGroup range="35-44" percentage="23"/>
        </analytics:Demographics>
      </analytics:Performance>
      <ml:AudioAnalysis>
        <ml:Tempo>132.5</ml:Tempo>
        <ml:Key>C Major</ml:Key>
        <ml:Mood confidence="0.92">euphoric</ml:Mood>
        <ml:Genre confidence="0.87">electronic-orchestral</ml:Genre>
        <ml:Instruments>
          <ml:Instrument confidence="0.95">synthesizer</ml:Instrument>
          <ml:Instrument confidence="0.88">strings</ml:Instrument>
          <ml:Instrument confidence="0.76">piano</ml:Instrument>
        </ml:Instruments>
      </ml:AudioAnalysis>
      <DisplayArtist>
        <PartyName>
          <FullName>AI Composer</FullName>
        </PartyName>
        <ml:ArtistType>hybrid</ml:ArtistType>
      </DisplayArtist>
    </SoundRecording>
  </ResourceList>
  <analytics:MessageFooter>
    <analytics:ProcessingTime>PT0.247S</analytics:ProcessingTime>
    <analytics:ValidationScore>98.5</analytics:ValidationScore>
    <analytics:ExtensionCount>15</analytics:ExtensionCount>
  </analytics:MessageFooter>
</ern:NewReleaseMessage>"#;

/// Simple DDEX XML without extensions for comparison
pub const DDEX_WITHOUT_EXTENSIONS: &str = r#"<?xml version="1.0" encoding="UTF-8"?>
<ern:NewReleaseMessage xmlns:ern="http://ddex.net/xml/ern/43">
  <MessageHeader>
    <MessageId>SIMPLE_MSG_20241201_005</MessageId>
    <MessageSender>
      <PartyName>Simple Label</PartyName>
    </MessageSender>
    <MessageRecipient>
      <PartyName>Simple Distributor</PartyName>
    </MessageRecipient>
    <MessageCreatedDateTime>2024-12-01T14:00:00Z</MessageCreatedDateTime>
  </MessageHeader>
  <ReleaseList>
    <Release>
      <ReleaseId>
        <ISRC>SIMPLE12300123</ISRC>
        <ProprietaryId>SIMPLE_REL_001</ProprietaryId>
      </ReleaseId>
      <ReleaseReference>R5</ReleaseReference>
      <ReferenceTitle>
        <TitleText>Basic Album</TitleText>
      </ReferenceTitle>
    </Release>
  </ReleaseList>
  <ResourceList>
    <SoundRecording>
      <ResourceReference>Track05</ResourceReference>
      <ReferenceTitle>
        <TitleText>Simple Song</TitleText>
      </ReferenceTitle>
      <SoundRecordingId>
        <ISRC>SIMPLE12300124</ISRC>
      </SoundRecordingId>
      <DisplayArtist>
        <PartyName>
          <FullName>Simple Artist</FullName>
        </PartyName>
      </DisplayArtist>
    </SoundRecording>
  </ResourceList>
</ern:NewReleaseMessage>"#;
