# printnanny-api-client
Official API client library for printnanny.ai

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.95.0
- Package version: 0.95.0
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen
For more information, please visit [https://printnanny.ai](https://printnanny.ai)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import printnanny_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import printnanny_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import printnanny_api_client
from printnanny_api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = printnanny_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'

# Configure Bearer authorization: tokenAuth
configuration = printnanny_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with printnanny_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = printnanny_api_client.AccountsApi(api_client)
    email_auth_request = printnanny_api_client.EmailAuthRequest() # EmailAuthRequest | 

    try:
        api_response = api_instance.accounts2fa_auth_email_create(email_auth_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccountsApi->accounts2fa_auth_email_create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**accounts2fa_auth_email_create**](docs/AccountsApi.md#accounts2fa_auth_email_create) | **POST** /accounts/2fa-auth/email/ | 
*AccountsApi* | [**accounts2fa_auth_token_create**](docs/AccountsApi.md#accounts2fa_auth_token_create) | **POST** /accounts/2fa-auth/token/ | 
*AccountsApi* | [**accounts_email_waitlist_create**](docs/AccountsApi.md#accounts_email_waitlist_create) | **POST** /api/accounts/email-waitlist/ | 
*AccountsApi* | [**accounts_login_create**](docs/AccountsApi.md#accounts_login_create) | **POST** /api/accounts/login/ | 
*AccountsApi* | [**accounts_logout_create**](docs/AccountsApi.md#accounts_logout_create) | **POST** /api/accounts/logout/ | 
*AccountsApi* | [**accounts_password_change_create**](docs/AccountsApi.md#accounts_password_change_create) | **POST** /api/accounts/password/change/ | 
*AccountsApi* | [**accounts_password_reset_confirm_create**](docs/AccountsApi.md#accounts_password_reset_confirm_create) | **POST** /api/accounts/password/reset/confirm/ | 
*AccountsApi* | [**accounts_password_reset_create**](docs/AccountsApi.md#accounts_password_reset_create) | **POST** /api/accounts/password/reset/ | 
*AccountsApi* | [**accounts_registration_create**](docs/AccountsApi.md#accounts_registration_create) | **POST** /api/accounts/registration/ | 
*AccountsApi* | [**accounts_registration_resend_email_create**](docs/AccountsApi.md#accounts_registration_resend_email_create) | **POST** /api/accounts/registration/resend-email/ | 
*AccountsApi* | [**accounts_registration_verify_email_create**](docs/AccountsApi.md#accounts_registration_verify_email_create) | **POST** /api/accounts/registration/verify-email/ | 
*AccountsApi* | [**accounts_user_partial_update**](docs/AccountsApi.md#accounts_user_partial_update) | **PATCH** /api/accounts/user/ | 
*AccountsApi* | [**accounts_user_retrieve**](docs/AccountsApi.md#accounts_user_retrieve) | **GET** /api/accounts/user/ | 
*AccountsApi* | [**accounts_user_update**](docs/AccountsApi.md#accounts_user_update) | **PUT** /api/accounts/user/ | 
*AlertSettingsApi* | [**alert_settings_create**](docs/AlertSettingsApi.md#alert_settings_create) | **POST** /api/alert-settings/ | 
*AlertSettingsApi* | [**alert_settings_list**](docs/AlertSettingsApi.md#alert_settings_list) | **GET** /api/alert-settings/ | 
*AlertSettingsApi* | [**alert_settings_partial_update**](docs/AlertSettingsApi.md#alert_settings_partial_update) | **PATCH** /api/alert-settings/{id}/ | 
*AlertSettingsApi* | [**alert_settings_update**](docs/AlertSettingsApi.md#alert_settings_update) | **PUT** /api/alert-settings/{id}/ | 
*AlertsApi* | [**alerts_create**](docs/AlertsApi.md#alerts_create) | **POST** /api/alerts/ | 
*AlertsApi* | [**alerts_list**](docs/AlertsApi.md#alerts_list) | **GET** /api/alerts/ | 
*AlertsApi* | [**alerts_partial_update**](docs/AlertsApi.md#alerts_partial_update) | **PATCH** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_recent**](docs/AlertsApi.md#alerts_recent) | **GET** /api/alerts/recent/ | 
*AlertsApi* | [**alerts_retrieve**](docs/AlertsApi.md#alerts_retrieve) | **GET** /api/alerts/{id}/ | 
*AlertsApi* | [**alerts_seen**](docs/AlertsApi.md#alerts_seen) | **PATCH** /api/alerts/seen/ | 
*AlertsApi* | [**alerts_unread**](docs/AlertsApi.md#alerts_unread) | **GET** /api/alerts/unread/ | 
*AlertsApi* | [**alerts_update**](docs/AlertsApi.md#alerts_update) | **PUT** /api/alerts/{id}/ | 
*BillingApi* | [**billing_summary_retrieve**](docs/BillingApi.md#billing_summary_retrieve) | **GET** /api/billing/summary | 
*CommandsApi* | [**commands_create**](docs/CommandsApi.md#commands_create) | **POST** /api/commands/ | 
*CommandsApi* | [**commands_list**](docs/CommandsApi.md#commands_list) | **GET** /api/commands/ | 
*CommandsApi* | [**commands_retrieve**](docs/CommandsApi.md#commands_retrieve) | **GET** /api/commands/{id}/ | 
*DevicesApi* | [**cloudiot_device_update_or_create**](docs/DevicesApi.md#cloudiot_device_update_or_create) | **POST** /api/devices/{device_id}/cloudiot/update-or-create/ | 
*DevicesApi* | [**devices_cloudiot_create**](docs/DevicesApi.md#devices_cloudiot_create) | **POST** /api/devices/{device_id}/cloudiot/ | 
*DevicesApi* | [**devices_cloudiot_list**](docs/DevicesApi.md#devices_cloudiot_list) | **GET** /api/devices/{device_id}/cloudiot/ | 
*DevicesApi* | [**devices_cloudiot_partial_update**](docs/DevicesApi.md#devices_cloudiot_partial_update) | **PATCH** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_cloudiot_retrieve**](docs/DevicesApi.md#devices_cloudiot_retrieve) | **GET** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_cloudiot_update**](docs/DevicesApi.md#devices_cloudiot_update) | **PUT** /api/devices/{device_id}/cloudiot/{id}/ | 
*DevicesApi* | [**devices_config_download_retrieve**](docs/DevicesApi.md#devices_config_download_retrieve) | **GET** /api/devices/{device_id}/config/download/ | 
*DevicesApi* | [**devices_create**](docs/DevicesApi.md#devices_create) | **POST** /api/devices/ | 
*DevicesApi* | [**devices_list**](docs/DevicesApi.md#devices_list) | **GET** /api/devices/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **PATCH** /api/devices/{id}/ | 
*DevicesApi* | [**devices_public_keys_create**](docs/DevicesApi.md#devices_public_keys_create) | **POST** /api/devices/{device_id}/public-keys/ | 
*DevicesApi* | [**devices_public_keys_list**](docs/DevicesApi.md#devices_public_keys_list) | **GET** /api/devices/{device_id}/public-keys/ | 
*DevicesApi* | [**devices_public_keys_partial_update**](docs/DevicesApi.md#devices_public_keys_partial_update) | **PATCH** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_public_keys_retrieve**](docs/DevicesApi.md#devices_public_keys_retrieve) | **GET** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_public_keys_update**](docs/DevicesApi.md#devices_public_keys_update) | **PUT** /api/devices/{device_id}/public-keys/{id}/ | 
*DevicesApi* | [**devices_retrieve**](docs/DevicesApi.md#devices_retrieve) | **GET** /api/devices/{id}/ | 
*DevicesApi* | [**devices_retrieve_hostname**](docs/DevicesApi.md#devices_retrieve_hostname) | **GET** /api/devices/{hostname} | 
*DevicesApi* | [**devices_settings_create**](docs/DevicesApi.md#devices_settings_create) | **POST** /api/devices/{device_id}/settings/ | 
*DevicesApi* | [**devices_settings_list**](docs/DevicesApi.md#devices_settings_list) | **GET** /api/devices/{device_id}/settings/ | 
*DevicesApi* | [**devices_settings_partial_update**](docs/DevicesApi.md#devices_settings_partial_update) | **PATCH** /api/devices/{device_id}/settings/{id}/ | 
*DevicesApi* | [**devices_settings_retrieve**](docs/DevicesApi.md#devices_settings_retrieve) | **GET** /api/devices/{device_id}/settings/{id}/ | 
*DevicesApi* | [**devices_settings_update**](docs/DevicesApi.md#devices_settings_update) | **PUT** /api/devices/{device_id}/settings/{id}/ | 
*DevicesApi* | [**devices_system_info_create**](docs/DevicesApi.md#devices_system_info_create) | **POST** /api/devices/{device_id}/system-info/ | 
*DevicesApi* | [**devices_system_info_list**](docs/DevicesApi.md#devices_system_info_list) | **GET** /api/devices/{device_id}/system-info/ | 
*DevicesApi* | [**devices_system_info_partial_update**](docs/DevicesApi.md#devices_system_info_partial_update) | **PATCH** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_system_info_retrieve**](docs/DevicesApi.md#devices_system_info_retrieve) | **GET** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_system_info_update**](docs/DevicesApi.md#devices_system_info_update) | **PUT** /api/devices/{device_id}/system-info/{id}/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **PUT** /api/devices/{id}/ | 
*DevicesApi* | [**devices_webrtc_streams_create**](docs/DevicesApi.md#devices_webrtc_streams_create) | **POST** /api/devices/{device_id}/webrtc-streams/ | 
*DevicesApi* | [**devices_webrtc_streams_list**](docs/DevicesApi.md#devices_webrtc_streams_list) | **GET** /api/devices/{device_id}/webrtc-streams/ | 
*DevicesApi* | [**devices_webrtc_streams_partial_update**](docs/DevicesApi.md#devices_webrtc_streams_partial_update) | **PATCH** /api/devices/{device_id}/webrtc-streams/{id}/ | 
*DevicesApi* | [**devices_webrtc_streams_retrieve**](docs/DevicesApi.md#devices_webrtc_streams_retrieve) | **GET** /api/devices/{device_id}/webrtc-streams/{id}/ | 
*DevicesApi* | [**devices_webrtc_streams_update**](docs/DevicesApi.md#devices_webrtc_streams_update) | **PUT** /api/devices/{device_id}/webrtc-streams/{id}/ | 
*DevicesApi* | [**public_key_update_or_create**](docs/DevicesApi.md#public_key_update_or_create) | **POST** /api/devices/{device_id}/public-keys/update-or-create/ | 
*DevicesApi* | [**system_info_update_or_create**](docs/DevicesApi.md#system_info_update_or_create) | **POST** /api/devices/{device_id}/system-info/update-or-create/ | 
*EventsApi* | [**commands_create**](docs/EventsApi.md#commands_create) | **POST** /api/commands/ | 
*EventsApi* | [**commands_list**](docs/EventsApi.md#commands_list) | **GET** /api/commands/ | 
*EventsApi* | [**commands_retrieve**](docs/EventsApi.md#commands_retrieve) | **GET** /api/commands/{id}/ | 
*EventsApi* | [**events_create**](docs/EventsApi.md#events_create) | **POST** /api/events/ | 
*EventsApi* | [**events_list**](docs/EventsApi.md#events_list) | **GET** /api/events/ | 
*EventsApi* | [**events_retrieve**](docs/EventsApi.md#events_retrieve) | **GET** /api/events/{id}/ | 
*JanusApi* | [**devices_webrtc_streams_create**](docs/JanusApi.md#devices_webrtc_streams_create) | **POST** /api/devices/{device_id}/webrtc-streams/ | 
*JanusApi* | [**devices_webrtc_streams_list**](docs/JanusApi.md#devices_webrtc_streams_list) | **GET** /api/devices/{device_id}/webrtc-streams/ | 
*JanusApi* | [**devices_webrtc_streams_retrieve**](docs/JanusApi.md#devices_webrtc_streams_retrieve) | **GET** /api/devices/{device_id}/webrtc-streams/{id}/ | 
*OctoprintApi* | [**devices_octoprint_list**](docs/OctoprintApi.md#devices_octoprint_list) | **GET** /api/devices/{device_id}/octoprint/ | 
*OctoprintApi* | [**octoprint_backups_create**](docs/OctoprintApi.md#octoprint_backups_create) | **POST** /api/octoprint/backups/ | 
*OctoprintApi* | [**octoprint_backups_list**](docs/OctoprintApi.md#octoprint_backups_list) | **GET** /api/octoprint/backups/ | 
*OctoprintApi* | [**octoprint_backups_retrieve**](docs/OctoprintApi.md#octoprint_backups_retrieve) | **GET** /api/octoprint/backups/{id}/ | 
*OctoprintApi* | [**octoprint_create**](docs/OctoprintApi.md#octoprint_create) | **POST** /api/octoprint/ | 
*OctoprintApi* | [**octoprint_gcode_files_create**](docs/OctoprintApi.md#octoprint_gcode_files_create) | **POST** /api/octoprint/gcode-files/ | 
*OctoprintApi* | [**octoprint_gcode_files_list**](docs/OctoprintApi.md#octoprint_gcode_files_list) | **GET** /api/octoprint/gcode-files/ | 
*OctoprintApi* | [**octoprint_gcode_files_retrieve**](docs/OctoprintApi.md#octoprint_gcode_files_retrieve) | **GET** /api/octoprint/gcode-files/{id}/ | 
*OctoprintApi* | [**octoprint_list**](docs/OctoprintApi.md#octoprint_list) | **GET** /api/octoprint/ | 
*OctoprintApi* | [**octoprint_partial_update**](docs/OctoprintApi.md#octoprint_partial_update) | **PATCH** /api/octoprint/{id}/ | 
*OctoprintApi* | [**octoprint_printer_profiles_create**](docs/OctoprintApi.md#octoprint_printer_profiles_create) | **POST** /api/octoprint/printer-profiles/ | 
*OctoprintApi* | [**octoprint_printer_profiles_list**](docs/OctoprintApi.md#octoprint_printer_profiles_list) | **GET** /api/octoprint/printer-profiles/ | 
*OctoprintApi* | [**octoprint_printer_profiles_partial_update**](docs/OctoprintApi.md#octoprint_printer_profiles_partial_update) | **PATCH** /api/octoprint/printer-profiles/{id}/ | 
*OctoprintApi* | [**octoprint_printer_profiles_update**](docs/OctoprintApi.md#octoprint_printer_profiles_update) | **PUT** /api/octoprint/printer-profiles/{id}/ | 
*OctoprintApi* | [**octoprint_profile_update_or_create**](docs/OctoprintApi.md#octoprint_profile_update_or_create) | **POST** /api/octoprint/printer-profiles/update-or-create/ | 
*OctoprintApi* | [**octoprint_server_update_or_create**](docs/OctoprintApi.md#octoprint_server_update_or_create) | **POST** /api/octoprint/update-or-create/ | 
*OctoprintApi* | [**octoprint_settings_create**](docs/OctoprintApi.md#octoprint_settings_create) | **POST** /api/octoprint/settings/ | 
*OctoprintApi* | [**octoprint_settings_list**](docs/OctoprintApi.md#octoprint_settings_list) | **GET** /api/octoprint/settings/ | 
*OctoprintApi* | [**octoprint_settings_partial_update**](docs/OctoprintApi.md#octoprint_settings_partial_update) | **PATCH** /api/octoprint/settings/{id}/ | 
*OctoprintApi* | [**octoprint_settings_update**](docs/OctoprintApi.md#octoprint_settings_update) | **PUT** /api/octoprint/settings/{id}/ | 
*OctoprintApi* | [**octoprint_settings_update_or_create**](docs/OctoprintApi.md#octoprint_settings_update_or_create) | **POST** /api/octoprint/settings/update-or-create/ | 
*OctoprintApi* | [**octoprint_update**](docs/OctoprintApi.md#octoprint_update) | **PUT** /api/octoprint/{id}/ | 
*SchemaApi* | [**schema_retrieve**](docs/SchemaApi.md#schema_retrieve) | **GET** /api/schema/ | 


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertBulkResponse](docs/AlertBulkResponse.md)
 - [AlertMethodsEnum](docs/AlertMethodsEnum.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [AlertSettings](docs/AlertSettings.md)
 - [AlertSettingsRequest](docs/AlertSettingsRequest.md)
 - [BillingSummary](docs/BillingSummary.md)
 - [CallbackTokenAuthRequest](docs/CallbackTokenAuthRequest.md)
 - [CloudiotDevice](docs/CloudiotDevice.md)
 - [CloudiotDeviceRequest](docs/CloudiotDeviceRequest.md)
 - [CollectionMethodEnum](docs/CollectionMethodEnum.md)
 - [Config](docs/Config.md)
 - [DetailResponse](docs/DetailResponse.md)
 - [Device](docs/Device.md)
 - [DeviceRequest](docs/DeviceRequest.md)
 - [DeviceSettings](docs/DeviceSettings.md)
 - [DeviceSettingsRequest](docs/DeviceSettingsRequest.md)
 - [DeviceUrls](docs/DeviceUrls.md)
 - [EmailAuthRequest](docs/EmailAuthRequest.md)
 - [EmailWaitlist](docs/EmailWaitlist.md)
 - [EmailWaitlistRequest](docs/EmailWaitlistRequest.md)
 - [EndBehaviorEnum](docs/EndBehaviorEnum.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [EventSource](docs/EventSource.md)
 - [EventTypeEnum](docs/EventTypeEnum.md)
 - [EventTypesEnum](docs/EventTypesEnum.md)
 - [GcodeFile](docs/GcodeFile.md)
 - [IntervalEnum](docs/IntervalEnum.md)
 - [JanusConfigType](docs/JanusConfigType.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [OctoPrintBackup](docs/OctoPrintBackup.md)
 - [OctoPrintEvent](docs/OctoPrintEvent.md)
 - [OctoPrintEventModel](docs/OctoPrintEventModel.md)
 - [OctoPrintEventName](docs/OctoPrintEventName.md)
 - [OctoPrintEventRequest](docs/OctoPrintEventRequest.md)
 - [OctoPrintServer](docs/OctoPrintServer.md)
 - [OctoPrintServerRequest](docs/OctoPrintServerRequest.md)
 - [OctoPrintSettings](docs/OctoPrintSettings.md)
 - [OctoPrintSettingsRequest](docs/OctoPrintSettingsRequest.md)
 - [OctoPrinterProfile](docs/OctoPrinterProfile.md)
 - [OctoPrinterProfileRequest](docs/OctoPrinterProfileRequest.md)
 - [PaginatedAlertList](docs/PaginatedAlertList.md)
 - [PaginatedCloudiotDeviceList](docs/PaginatedCloudiotDeviceList.md)
 - [PaginatedDeviceList](docs/PaginatedDeviceList.md)
 - [PaginatedDeviceSettingsList](docs/PaginatedDeviceSettingsList.md)
 - [PaginatedGcodeFileList](docs/PaginatedGcodeFileList.md)
 - [PaginatedOctoPrintBackupList](docs/PaginatedOctoPrintBackupList.md)
 - [PaginatedOctoPrintServerList](docs/PaginatedOctoPrintServerList.md)
 - [PaginatedOctoPrintSettingsList](docs/PaginatedOctoPrintSettingsList.md)
 - [PaginatedOctoPrinterProfileList](docs/PaginatedOctoPrinterProfileList.md)
 - [PaginatedPolymorphicCommandList](docs/PaginatedPolymorphicCommandList.md)
 - [PaginatedPolymorphicEventList](docs/PaginatedPolymorphicEventList.md)
 - [PaginatedPublicKeyList](docs/PaginatedPublicKeyList.md)
 - [PaginatedSystemInfoList](docs/PaginatedSystemInfoList.md)
 - [PaginatedWebrtcStreamList](docs/PaginatedWebrtcStreamList.md)
 - [PasswordChangeRequest](docs/PasswordChangeRequest.md)
 - [PasswordResetConfirmRequest](docs/PasswordResetConfirmRequest.md)
 - [PasswordResetRequest](docs/PasswordResetRequest.md)
 - [PatchedAlertBulkRequestRequest](docs/PatchedAlertBulkRequestRequest.md)
 - [PatchedAlertRequest](docs/PatchedAlertRequest.md)
 - [PatchedAlertSettingsRequest](docs/PatchedAlertSettingsRequest.md)
 - [PatchedCloudiotDeviceRequest](docs/PatchedCloudiotDeviceRequest.md)
 - [PatchedDeviceRequest](docs/PatchedDeviceRequest.md)
 - [PatchedDeviceSettingsRequest](docs/PatchedDeviceSettingsRequest.md)
 - [PatchedOctoPrintServerRequest](docs/PatchedOctoPrintServerRequest.md)
 - [PatchedOctoPrintSettingsRequest](docs/PatchedOctoPrintSettingsRequest.md)
 - [PatchedOctoPrinterProfileRequest](docs/PatchedOctoPrinterProfileRequest.md)
 - [PatchedPublicKeyRequest](docs/PatchedPublicKeyRequest.md)
 - [PatchedSystemInfoRequest](docs/PatchedSystemInfoRequest.md)
 - [PatchedUserRequest](docs/PatchedUserRequest.md)
 - [PatchedWebrtcStreamRequest](docs/PatchedWebrtcStreamRequest.md)
 - [PolymorphicCommand](docs/PolymorphicCommand.md)
 - [PolymorphicCommandCreateRequest](docs/PolymorphicCommandCreateRequest.md)
 - [PolymorphicEvent](docs/PolymorphicEvent.md)
 - [PolymorphicEventCreateRequest](docs/PolymorphicEventCreateRequest.md)
 - [PrintNannyApiConfig](docs/PrintNannyApiConfig.md)
 - [PublicKey](docs/PublicKey.md)
 - [PublicKeyRequest](docs/PublicKeyRequest.md)
 - [RegisterRequest](docs/RegisterRequest.md)
 - [ResendEmailVerificationRequest](docs/ResendEmailVerificationRequest.md)
 - [RestAuthDetail](docs/RestAuthDetail.md)
 - [StripeCustomer](docs/StripeCustomer.md)
 - [StripePaymentMethod](docs/StripePaymentMethod.md)
 - [StripePlan](docs/StripePlan.md)
 - [StripeSubscription](docs/StripeSubscription.md)
 - [StripeSubscriptionSchedule](docs/StripeSubscriptionSchedule.md)
 - [StripeSubscriptionScheduleStatusEnum](docs/StripeSubscriptionScheduleStatusEnum.md)
 - [StripeSubscriptionStatusEnum](docs/StripeSubscriptionStatusEnum.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [SystemInfoRequest](docs/SystemInfoRequest.md)
 - [TaxExemptEnum](docs/TaxExemptEnum.md)
 - [TestEvent](docs/TestEvent.md)
 - [TestEventModel](docs/TestEventModel.md)
 - [TestEventName](docs/TestEventName.md)
 - [TestEventRequest](docs/TestEventRequest.md)
 - [Token](docs/Token.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [TypeEnum](docs/TypeEnum.md)
 - [UsageTypeEnum](docs/UsageTypeEnum.md)
 - [User](docs/User.md)
 - [UserRequest](docs/UserRequest.md)
 - [VerifyEmailRequest](docs/VerifyEmailRequest.md)
 - [WebRTCCommand](docs/WebRTCCommand.md)
 - [WebRTCCommandCreateRequest](docs/WebRTCCommandCreateRequest.md)
 - [WebRTCCommandModel](docs/WebRTCCommandModel.md)
 - [WebRTCCommandName](docs/WebRTCCommandName.md)
 - [WebRTCEvent](docs/WebRTCEvent.md)
 - [WebRTCEventModel](docs/WebRTCEventModel.md)
 - [WebRTCEventName](docs/WebRTCEventName.md)
 - [WebRTCEventRequest](docs/WebRTCEventRequest.md)
 - [WebrtcStream](docs/WebrtcStream.md)
 - [WebrtcStreamRequest](docs/WebrtcStreamRequest.md)


## Documentation For Authorization


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## tokenAuth

- **Type**: Bearer authentication


## Author

leigh@printnanny.ai


